/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardDataNameDao;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.model.StandardDataName;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMgmtStandardDataExportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtStandardDataExportService.class);
    @Autowired
    ApiMgmtStandardDataNameDao standardDataNameDao;

    public synchronized void execute(OutputStream out) throws BaseException {
        ArrayList<Map<String, Object>> sheetsList = new ArrayList<Map<String, Object>>();
        try {
            List<StandardDataName> unApprovedList = this.standardDataNameDao.getDataNameByApprovedStatus(1L, false);
            this.export(unApprovedList, sheetsList);
            Workbook workBook = ExcelExportUtil.exportExcel(sheetsList, (ExcelType)ExcelType.HSSF);
            workBook.write(out);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private <T> void export(List<T> list, List<Map<String, Object>> sheetsList) {
        ExportParams deptExportParams = new ExportParams();
        deptExportParams.setSheetName("\u8fad\u5f59\u6e05\u55ae_\u5be9\u68381");
        HashMap<String, Object> deptExportMap = new HashMap<String, Object>();
        deptExportMap.put("title", deptExportParams);
        deptExportMap.put("entity", StandardDataName.class);
        deptExportMap.put("data", list);
        sheetsList.add(deptExportMap);
    }
}

