/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.common.model.dto.FileDto;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardDataNameDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStateCodeDao;
import com.digiwin.athena.apimgmt.enums.ValidateStateEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.StandardDataName;
import com.digiwin.athena.apimgmt.model.StateCode;
import com.digiwin.athena.apimgmt.util.ExcelUtil;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ApiMgmtStandardDataImportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtStandardDataImportService.class);
    ObjectMapper mapper = new ObjectMapper();
    @Autowired
    ApiMgmtStateCodeDao stateCodeDao;
    @Autowired
    ApiMgmtStandardDataNameDao standardDataNameDao;

    public synchronized Map<String, Object> execute(FileDto file) throws BaseException {
        ObjectNode tResponseNode = this.mapper.createObjectNode();
        StateCode tStateCode = this.stateCodeDao.getStateCodeByCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = tStateCode.getDescription();
        StringBuilder tDescriptionBuilder = new StringBuilder();
        try {
            String tToken = ApiMgmtServiceContextHolder.getToken();
            if (null == tToken) {
                throw new Exception("token\u672a\u586b\u5199\uff01");
            }
            String tUserId = ApiMgmtServiceContextHolder.getUserId();
            if (null == tUserId) {
                throw new Exception("token\u89e3\u6790\u5931\u8d25\uff01");
            }
            ExcelImportResult<StandardDataName> result = this.importExcel(file, 0, 0, 1, StandardDataName.class);
            if (null != result && CollUtil.isNotEmpty((Collection)result.getList())) {
                result.getList().stream().filter(y -> null != y.getDataName()).forEach(x -> {
                    StandardDataName standardDataName = (StandardDataName)this.standardDataNameDao.get(x.getDataName());
                    if (null != standardDataName) {
                        standardDataName.setDescriptionEnUs(StringUtil.isEmptyOrSpace((Object)x.getDescriptionEnUs()) ? x.getDescriptionZhTw() : x.getDescriptionEnUs());
                        standardDataName.setDescriptionZhCn(x.getDescriptionZhCn());
                        standardDataName.setDescriptionZhTw(x.getDescriptionZhTw());
                        standardDataName.setTypeEnUs(x.getTypeEnUs());
                        standardDataName.setTypeZhCn(x.getTypeZhCn());
                        standardDataName.setTypeZhTw(x.getTypeZhTw());
                        standardDataName.setUnitOrDefaultZhTw(x.getUnitOrDefaultZhTw());
                        standardDataName.setUnitOrDefaultZhCn(x.getUnitOrDefaultZhTw());
                        standardDataName.setUnitOrDefaultEnUs(x.getUnitOrDefaultZhTw());
                        standardDataName.setRemarkZhTw(x.getRemarkZhTw());
                        standardDataName.setRemarkZhCn(x.getRemarkZhTw());
                        standardDataName.setRemarkEnUs(x.getRemarkZhTw());
                        standardDataName.setApprovedStatus(4L);
                        standardDataName.setApprovedAcct(tUserId);
                        standardDataName.setApprovedTime(LocalDateTime.now());
                        standardDataName.setLastUpdateTime(LocalDateTime.now());
                        this.standardDataNameDao.update(standardDataName);
                    }
                });
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            tStateCode = this.stateCodeDao.getStateCodeByCode(ValidateStateEnum.UNEXPECTED_ERROR.getCode());
            tDescriptionBuilder.append(tStateCode.getDescription()).append(" ").append(e.getClass().toString()).append(":").append(e.getMessage());
            tDescription = tDescriptionBuilder.toString();
        }
        tResponseNode.put("code", tStateCode.getCode());
        tResponseNode.put("description", tDescription);
        log.info("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3\uff1a" + this.getClass() + "\uff0c\u56de\u50b3\u8a0a\u606f\uff1a" + tResponseNode.toString());
        return (Map)this.mapper.convertValue((Object)tResponseNode, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public <T> ExcelImportResult<T> importExcel(FileDto file, int startRows, int index, int headRows, Class<T> tClass) {
        ImportParams params = new ImportParams();
        params.setStartRows(startRows);
        params.setStartSheetIndex(index);
        params.setTitleRows(0);
        params.setHeadRows(headRows);
        params.setNeedVerify(false);
        return ExcelUtil.importExcel(file, params, tClass);
    }
}

