/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.apimgmt.dao.ApiMgmtApiParamTextDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dto.ApiParamTextReqDto;
import com.digiwin.athena.apimgmt.dto.ApiParamTextResDto;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.DeveloperRoleEnum;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.enums.MessageFormatEnum;
import com.digiwin.athena.apimgmt.enums.MessageTextSampleTypeEnum;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.ApiParamText;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import com.digiwin.athena.apimgmt.service.util.StandardApiMessageServiceUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ApiParamTextService {
    @Autowired
    private ApiMgmtApiParamTextDao apiParamTextDao;
    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;
    ObjectMapper mapper = new ObjectMapper();

    @Transactional(rollbackFor={Exception.class})
    public ApiParamText save(ApiParamTextReqDto apiParamTextReqDto) throws Exception {
        String userId = ApiMgmtServiceContextHolder.getUserId();
        if (apiParamTextReqDto.getTextId() != null) {
            ApiParamText oldApiParamText = (ApiParamText)this.apiParamTextDao.get(apiParamTextReqDto.getTextId());
            Assert.notNull((Object)oldApiParamText, (String)"\u8bf7\u6c42\u8303\u672c\u4e0d\u5b58\u5728");
            if (apiParamTextReqDto.getRequestText() != null) {
                oldApiParamText.setRequestText(JSONObject.toJSONString((Object)apiParamTextReqDto.getRequestText()));
            }
            if (apiParamTextReqDto.getResponseText() != null) {
                oldApiParamText.setResponseText(JSONObject.toJSONString((Object)apiParamTextReqDto.getResponseText()));
            }
            oldApiParamText.setEditTime(new Date());
            oldApiParamText.setEditBy(userId);
            return this.apiParamTextDao.save(oldApiParamText);
        }
        ApiParamText apiParamText = new ApiParamText();
        if (apiParamTextReqDto.getRequestText() != null) {
            apiParamText.setRequestText(JSONObject.toJSONString((Object)apiParamTextReqDto.getRequestText()));
        }
        if (apiParamTextReqDto.getResponseText() != null) {
            apiParamText.setResponseText(JSONObject.toJSONString((Object)apiParamTextReqDto.getResponseText()));
        }
        apiParamText.setCreatedBy(userId);
        apiParamText.setEditBy(userId);
        apiParamText.setCreatedTime(new Date());
        apiParamText.setEditTime(new Date());
        return this.apiParamTextDao.save(apiParamText);
    }

    public ApiParamTextResDto getApiParamText(Long textId) {
        ApiParamText apiParamText = (ApiParamText)this.apiParamTextDao.get(textId);
        Assert.notNull((Object)apiParamText, (String)"\u8bf7\u6c42\u8303\u672c\u4e0d\u5b58\u5728");
        return ApiParamTextResDto.create(apiParamText);
    }

    public String generateApiParamText(String body) throws IOException {
        JsonNode tRequestNode = this.mapper.readTree(body);
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        String tApiName = tRequestNode.get(ApiAttributeEnum.apiName.toString()).asText();
        String branch = "1.0";
        String tServiceProduct = tRequestNode.get(ApiAttributeEnum.serviceProduct.toString()).asText();
        String tHostProduct = tRequestNode.get(ApiAttributeEnum.hostProduct.toString()).asText();
        String tMsgFormat = tRequestNode.get(ApiAttributeEnum.msgFormat.toString()).asText();
        String tDevelopRole = tRequestNode.get(ApiAttributeEnum.developRole.toString()).asText();
        String tMessageType = tRequestNode.get(ApiAttributeEnum.messageType.toString()).asText();
        String tTenant = "";
        if (tRequestNode.get(ApiAttributeEnum.tenantId.toString()) != null) {
            tTenant = tRequestNode.get(ApiAttributeEnum.tenantId.toString()).asText();
        }
        String tVersion = null;
        if (tRequestNode.get(ApiAttributeEnum.apiVersion.toString()) != null) {
            tVersion = tRequestNode.get(ApiAttributeEnum.apiVersion.toString()).asText();
            branch = ApiVersionServiceUtil.getBranchFromVersion(tVersion);
        }
        List<StandardApiVersion> tStandardApiVersionList = this.standardApiVersionDao.fetchApiVersionsByName(tApiName, branch, tTenant);
        StandardApiVersion tTargetApiVersion = null;
        for (StandardApiVersion tStandardApiVersion : tStandardApiVersionList) {
            if (!tStandardApiVersion.getVersion().equals(tVersion)) continue;
            tTargetApiVersion = tStandardApiVersion;
        }
        String tCustomUUID = UUID.randomUUID().toString();
        Map<String, String> tMessageMap = StandardApiMessageServiceUtil.generateStandardApiMessage(tTargetApiVersion.getId(), tTargetApiVersion.getStandardApi(), MessageFormatEnum.valueOf((String)tMsgFormat).getMsgFormat(), tHostProduct, tServiceProduct, MessageTextSampleTypeEnum.valueOf((String)tMessageType).toString(), DeveloperRoleEnum.valueOf((String)tDevelopRole).toString(), tCustomUUID, tLocale);
        String tMessageGenerated = tMessageMap.get("MESSAGE_GENERATED");
        return tMessageGenerated;
    }
}

