/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.annotate.OperateAuthorityVerify;
import com.digiwin.athena.apimgmt.apiservice.AbstractApiService;
import com.digiwin.athena.apimgmt.dao.ApiMgmtApprovedStatusDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtSyncMdcFailDataDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtMdcProp;
import com.digiwin.athena.apimgmt.model.ApprovedStatus;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.services.ApiMgmtSyncMdcServiceProcessor;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@OperateAuthorityVerify
public class ApiSpecRetrieveUpdateService
extends AbstractApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiSpecRetrieveUpdateService.class);
    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;
    @Autowired
    ApiMgmtApprovedStatusDao approvedStatusDao;
    @Autowired
    private ApiMgmtSyncMdcFailDataDao syncMdcFailDataDao;
    @Autowired
    private ApiMgmtSyncMdcServiceProcessor syncMdcServiceProcessor;
    @Autowired
    private ApiMgmtMdcProp mdcProp;

    public ApiSpecRetrieveUpdateService() {
        this.jsonSchemaFileName = "api_review_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        String tToken = ApiMgmtServiceContextHolder.getToken();
        String routerKey = ApiMgmtServiceContextHolder.getRouterKey();
        String tUserId = ApiMgmtServiceContextHolder.getUserId();
        ArrayNode tApiArrayNode = (ArrayNode)tRequestJsonNode.get("apiList");
        ArrayList<Long> versionList = new ArrayList<Long>();
        for (JsonNode tApiNode : tApiArrayNode) {
            StandardApiVersion tStandardApiVersion;
            HashMap<String, String> tConditionMap = new HashMap<String, String>();
            tConditionMap.put(ApiAttributeEnum.apiName.toString(), tApiNode.get(ApiAttributeEnum.apiName.toString()).asText());
            tConditionMap.put(ApiAttributeEnum.version.toString(), tApiNode.get(ApiAttributeEnum.version.toString()).asText());
            if (tApiNode.get(ApiAttributeEnum.tenantId.toString()) != null) {
                tConditionMap.put(ApiAttributeEnum.tenantId.toString(), tApiNode.get(ApiAttributeEnum.tenantId.toString()).asText());
            }
            if ((tStandardApiVersion = this.standardApiVersionDao.fetchApiVersion(tConditionMap)) == null || tStandardApiVersion.getApprovedStatus().getId() != 3L) continue;
            ApprovedStatus tApprovedStatus = (ApprovedStatus)this.approvedStatusDao.get(1L);
            tStandardApiVersion.setApprovedStatus(tApprovedStatus);
            tStandardApiVersion.setApprovedTime(LocalDateTime.now());
            this.standardApiVersionDao.saveOrupdate(tStandardApiVersion);
            this.syncMdcFailDataDao.removeByApiVerId(tStandardApiVersion.getId());
            versionList.add(tStandardApiVersion.getId());
        }
        if (CollUtil.isNotEmpty(versionList) && CollUtil.isNotEmpty((Collection)this.mdcProp.getReviewUrlList())) {
            for (String url : this.mdcProp.getReviewUrlList()) {
                this.syncMdcServiceProcessor.runSyncMdcMetadataDel(versionList, url, true, tUserId, tToken, routerKey);
            }
        }
        HashMap<String, Object> tResponse = new HashMap<String, Object>();
        tResponse.put("code", "000");
        tResponse.put("result", "success");
        return tResponse;
    }
}

