/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.ApiMgmtApplicationParameter;
import com.digiwin.athena.apimgmt.annotate.OperateAuthorityVerify;
import com.digiwin.athena.apimgmt.apiservice.AbstractApiService;
import com.digiwin.athena.apimgmt.apiservice.ApiParamTextService;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectVersionRelationDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardDataNameDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtTenantConfigDao;
import com.digiwin.athena.apimgmt.dto.ApiParamTextReqDto;
import com.digiwin.athena.apimgmt.enums.APIExportImportEnums;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.enums.ValidateStateEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.exception.TeamIdNotFindValidationException;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.ApiParamText;
import com.digiwin.athena.apimgmt.model.ApprovedStatus;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.model.StateCode;
import com.digiwin.athena.apimgmt.service.util.ApiDataNameServiceUtil;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import com.digiwin.athena.apimgmt.service.util.DmcFileServiceUtil;
import com.digiwin.athena.apimgmt.service.util.StandardApiExportServiceUtil;
import com.digiwin.athena.apimgmt.service.util.StandardApiFileReadServiceUtil;
import com.digiwin.athena.apimgmt.service.util.StandardApiSpecAnalyzeServiceUtil;
import com.digiwin.athena.apimgmt.services.ApiMgmtApiVersionService;
import com.digiwin.athena.apimgmt.services.ApiMgmtProductCategoryService;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
@OperateAuthorityVerify
public class ApiSpecSaveService
extends AbstractApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiSpecSaveService.class);
    private static final Lock LOCK = new ReentrantLock(true);
    @Autowired
    private ApiMgmtProjectVersionRelationDao projectVersionRelationDao;
    @Autowired
    private ApiMgmtApiVersionService apiVersionService;
    @Autowired
    private ApiMgmtStandardApiDao standardApiDao;
    @Autowired
    private ApiMgmtStandardApiVersionDao standardApiVersionDao;
    @Autowired
    private ApiMgmtStandardDataNameDao standardDataNameDao;
    @Autowired
    private ApiMgmtTenantConfigDao tenantConfigDao;
    @Autowired
    private ApiMgmtProductCategoryService productCategoryService;
    @Autowired
    private ApiParamTextService apiParamTextService;

    public ApiSpecSaveService() {
        this.jsonSchemaFileName = "api_spec_save_schema.json";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Map<String, Object> processData(ValidatorResult validatorResult) {
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = tStateCode.getDescription();
        StringBuilder tDescriptionBuilder = new StringBuilder();
        ObjectNode tResponseNode = this.mapper.createObjectNode();
        HashMap<String, List<Map<String, String>>> tTotalApiErrorMap = new HashMap<String, List<Map<String, String>>>();
        try {
            ApiParamTextReqDto apiParamText;
            String tTeamId = ApiMgmtServiceContextHolder.getTeamId();
            String teamType = ApiMgmtServiceContextHolder.getTeamType();
            String tTenantId = ApiMgmtServiceContextHolder.getTenantId();
            String tUserId = ApiMgmtServiceContextHolder.getUserId();
            if (StringUtil.isEmpty((Object)teamType)) {
                throw new TeamIdNotFindValidationException(this.getClass());
            }
            JsonNode tRequestJsonNode = validatorResult.getJsonContent();
            boolean tSkipReview = this.tenantConfigDao.getSkipReviewDataNameTenant(tTenantId);
            LOCK.lock();
            try {
                if (!tSkipReview) {
                    List<String> tDataNameList = ApiDataNameServiceUtil.getApiDataNameList();
                    Long tDataNameCount = this.standardDataNameDao.getDataNameCount();
                    if ((long)tDataNameList.size() != tDataNameCount) {
                        tDataNameList = this.standardDataNameDao.getAllDataName();
                        ApiDataNameServiceUtil.setApiDataNameList(tDataNameList);
                    }
                }
            }
            finally {
                LOCK.unlock();
            }
            StandardApi tStandardApi = new StandardApi();
            List<Map<String, String>> tSetStdApiResult = StandardApiSpecAnalyzeServiceUtil.setStandardApi(tStandardApi, tRequestJsonNode, tLocale);
            String tApiName = tStandardApi.getName();
            String tApiTenantId = tStandardApi.getTenantId();
            String tVersion = tStandardApi.getStandardApiVersions().get(0).getVersion();
            tStandardApi.setTeamId(tTeamId);
            tStandardApi.setTeamType(teamType);
            List<StandardApiVersion> tStandardApiVersionList = this.standardApiVersionDao.getExistApiVersion(tApiName, tApiTenantId, tVersion);
            if (CollUtil.isNotEmpty(tStandardApiVersionList)) {
                StandardApiVersion tStandardApiVersion = tStandardApiVersionList.get(0);
                if (StringUtils.isBlank((CharSequence)tStandardApi.getFirstApplicant())) {
                    tStandardApi.setFirstApplicant(tStandardApiVersion.getStandardApi().getFirstApplicant());
                }
                if (tStandardApiVersion.getApprovedStatus().getId() != 1L || !tStandardApiVersion.getUserId().equals(tUserId) || !StringUtil.isEmptyOrSpace((Object)tStandardApiVersion.getStandardApi().getDesignTenantId()) && !tStandardApiVersion.getStandardApi().getDesignTenantId().equals(tTenantId)) {
                    StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.API_VERSION_IS_EXIST.toString(), null, null, 0, 0, tLocale);
                    String tApiError = tApiName + "/" + tVersion;
                    tTotalApiErrorMap.put(tApiError, tSetStdApiResult);
                    return this.result(tStateCode, tDescription, tTotalApiErrorMap);
                }
            }
            String tPreviousVersion = ApiVersionServiceUtil.getPreviousVersion(tVersion);
            if (!this.apiVersionService.judgeNewBranch(tVersion).booleanValue()) {
                List<StandardApiVersion> tPreviStandardApiVersions = this.standardApiVersionDao.getExistApiVersion(tApiName, tApiTenantId, tPreviousVersion);
                if (tPreviStandardApiVersions.isEmpty()) {
                    StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.PREVI_API_VERSION_IS_EXIST.toString(), null, null, 0, 0, tLocale);
                } else {
                    String designTenantId;
                    StandardApi previousStandardApi = tPreviStandardApiVersions.get(0).getStandardApi();
                    ApprovedStatus previousApprovedStatus = tPreviStandardApiVersions.get(0).getApprovedStatus();
                    if (previousApprovedStatus.getId() != 4L) {
                        StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.PREVI_IS_DEVELOPING.toString(), null, null, 0, 0, tLocale);
                    }
                    if (!(null == tStandardApi.getParentApiName() || null != previousStandardApi.getParentApiName() && (null == previousStandardApi.getParentApiName() || tStandardApi.getParentApiName().equals(previousStandardApi.getParentApiName()) && tStandardApi.getParentBranch().equals(previousStandardApi.getParentBranch()) && tStandardApi.getParentApiTenantId().equals(previousStandardApi.getParentApiTenantId())))) {
                        StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.PARENT_NAME_INCONSISTENT.toString(), null, null, 0, 0, tLocale);
                    }
                    if (!previousStandardApi.getStandardApiSyncType().getId().equals(tStandardApi.getStandardApiSyncType().getId())) {
                        StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.SYNC_TYPE_CAN_NOT_CHANGE.toString(), null, null, 0, 0, tLocale);
                    }
                    if (!previousStandardApi.getIsBatch().equals(tStandardApi.getIsBatch())) {
                        StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.IS_BATCH_CAN_NOT_CHANGE.toString(), null, null, 0, 0, tLocale);
                    }
                    if (!tTenantId.equals(designTenantId = previousStandardApi.getDesignTenantId()) && !"1".equals(teamType)) {
                        HashMap<String, String> errorMap = new HashMap<String, String>();
                        errorMap.put("description", "\u5f53\u524d\u79df\u6237\u65e0\u6743\u9650\u6267\u884c\u5f53\u524d\u64cd\u4f5c");
                        errorMap.put("solution", "\u8bf7\u4f7f\u7528\u79df\u6237ID\uff1a" + designTenantId + "\u6267\u884c\u5f53\u524d\u64cd\u4f5c");
                        tSetStdApiResult.add(errorMap);
                    }
                }
            }
            if (tSetStdApiResult.size() != 0) {
                String tApiError = tApiName + "/" + tVersion;
                tTotalApiErrorMap.put(tApiError, tSetStdApiResult);
                return this.result(tStateCode, tDescription, tTotalApiErrorMap);
            }
            HashMap<String, StandardApiDataName> tAddDataName = new HashMap<String, StandardApiDataName>();
            List<Map<String, String>> tSetStdApiDataNameResult = StandardApiSpecAnalyzeServiceUtil.setStandardApiDataName(tStandardApi, tRequestJsonNode, tAddDataName, tLocale);
            if (!tSetStdApiDataNameResult.isEmpty()) {
                String tApiError = tApiName + "/" + tVersion;
                tTotalApiErrorMap.put(tApiError, tSetStdApiDataNameResult);
                return this.result(tStateCode, tDescription, tTotalApiErrorMap);
            }
            if (CollUtil.isNotEmpty(tStandardApiVersionList)) {
                for (StandardApiVersion tStandardApiVersion : tStandardApiVersionList) {
                    this.standardApiVersionDao.delete(tStandardApiVersion.getId(), false);
                }
            }
            if ((apiParamText = tStandardApi.getApiParamText()) != null) {
                ApiParamText newApiParamText = this.apiParamTextService.save(apiParamText);
                tStandardApi.setTextId(newApiParamText.getTextId());
            }
            this.standardApiDao.save(tStandardApi, true);
            this.productCategoryService.saveProductCategory(tStandardApi.getProvider());
        }
        catch (BaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            tStateCode = this.getStateCode(e.getStateEnum().getCode());
            tDescriptionBuilder.append(tStateCode.getDescription());
            if (!StringUtil.isEmptyOrSpace((Object)e.getMessage())) {
                tDescriptionBuilder.append(" ").append(e.getMessage());
            }
            tDescription = tDescriptionBuilder.toString();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            tStateCode = this.getStateCode(ValidateStateEnum.UNEXPECTED_ERROR.getCode());
            tDescriptionBuilder.append(tStateCode.getDescription()).append(" ").append(e.getClass().toString()).append(":").append(e.getMessage());
            tDescription = tDescriptionBuilder.toString();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        tResponseNode.put("code", tStateCode.getCode());
        tResponseNode.put("description", tDescription);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, tResponseNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    private Map<String, Object> result(StateCode tStateCode, String tDescription, Map<String, List<Map<String, String>>> pTotalApiErrorMap) throws Exception {
        ObjectNode tResponseNode = this.mapper.createObjectNode();
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, tResponseNode);
        tStateCode = this.getStateCode(ValidateStateEnum.IMPORT_SPEC_FORMAT_ERROR.getCode());
        tDescription = tStateCode.getDescription();
        HSSFWorkbook tHSSFWorkbook = StandardApiExportServiceUtil.getTemplateFile(false);
        HSSFSheet tErrorSheet = tHSSFWorkbook.createSheet("\u932f\u8aa4\u660e\u7d30");
        StandardApiFileReadServiceUtil.writeImportErrorFile((Sheet)tErrorSheet, pTotalApiErrorMap);
        String tFileName = ApiMgmtApplicationParameter._TEMPLATE_FILE_NAME;
        String tFileExportPath = ApiMgmtApplicationParameter._FILE_EXPORT_PATH + "/" + tFileName;
        FileOutputStream fileOut = new FileOutputStream(tFileExportPath);
        tHSSFWorkbook.write((OutputStream)fileOut);
        fileOut.close();
        int pFailedNum = pTotalApiErrorMap.keySet().size();
        DmcFileServiceUtil.uploadFileAndGenerateDownloadLink(tResponseNode, tFileExportPath, tFileName, true, pFailedNum);
        tResponseNode.put("code", tStateCode.getCode());
        tResponseNode.put("description", tDescription);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

