/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import com.digiwin.athena.apimgmt.apiservice.AbstractSearchModel;
import com.digiwin.athena.apimgmt.apiservice.CompareModel;
import com.digiwin.athena.apimgmt.apiservice.DataNameModel;
import com.digiwin.athena.apimgmt.apiservice.DataNameSearchModel;
import com.digiwin.athena.apimgmt.apiservice.DescCNSearchModel;
import com.digiwin.athena.apimgmt.apiservice.DescTWSearchModel;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardDataNameDao;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.StandardDataName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataNameSearchService
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataNameSearchService.class);
    @Autowired
    private ApiMgmtStandardDataNameDao standardDataNameDao;
    private static TreeSet<AbstractSearchModel> dataNameTreeSet;
    private static TreeSet<AbstractSearchModel> descTWTreeSet;
    private static TreeSet<AbstractSearchModel> descCNTreeSet;

    public Map<String, Object> execute(String dataName) throws Exception {
        log.info("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3\uff1a" + this.getClass() + "\uff0c\u539f\u59cb\u8a0a\u606f\uff1a {\"dataName\":\"" + dataName + "\"}");
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        LinkedHashMap<String, Object> tResponse = new LinkedHashMap<String, Object>();
        ArrayList<DataNameModel> tDataNameModelList = new ArrayList<DataNameModel>();
        int count = 0;
        TreeSet<AbstractSearchModel> searchSet = dataNameTreeSet;
        if (!dataName.matches("[a-z][a-z_]+")) {
            switch (tLocale) {
                case "zh_TW": {
                    searchSet = descTWTreeSet;
                    break;
                }
                case "zh_CN": {
                    searchSet = descCNTreeSet;
                }
            }
        }
        SortedSet<AbstractSearchModel> sub = searchSet.subSet(new CompareModel(dataName), new CompareModel(dataName + '\uffff'));
        for (AbstractSearchModel abstractSearchModel : sub) {
            tDataNameModelList.add(abstractSearchModel.getDataNameModel());
            if (++count <= 10) continue;
            break;
        }
        if (count < 10) {
            for (AbstractSearchModel temp : searchSet) {
                if (!temp.getEqualValue().contains(dataName) || tDataNameModelList.contains(temp.getDataNameModel())) continue;
                tDataNameModelList.add(temp.getDataNameModel());
                if (++count <= 10) continue;
                break;
            }
        }
        for (DataNameModel tDataNameModel : tDataNameModelList) {
            HashMap<String, Object> tDataNameMap = new HashMap<String, Object>();
            HashMap<String, String> tMultilingualMap = new HashMap<String, String>();
            tMultilingualMap.put("zh_TW", tDataNameModel.getDescTW());
            tMultilingualMap.put("zh_CN", tDataNameModel.getDescCN());
            tMultilingualMap.put("en_US", tDataNameModel.getDescEn());
            tDataNameMap.put("dataDescriptionMultilingual", tMultilingualMap);
            tDataNameMap.put("dataName", tDataNameModel.getDataName());
            String tDesc = tDataNameModel.getDescCN();
            switch (tLocale) {
                case "zh_TW": {
                    tDesc = tDataNameModel.getDescTW();
                    break;
                }
                case "zh_CN": {
                    tDesc = tDataNameModel.getDescEn();
                }
            }
            tResponse.put(tDataNameModel.getDataName() + "(" + tDesc + ")", tDataNameMap);
        }
        return tResponse;
    }

    public void reloadDataNameToTreeSet() {
        TreeSet<DataNameSearchModel> dataNameTreeSetTemp = new TreeSet<DataNameSearchModel>();
        TreeSet<DescTWSearchModel> descTWTreeSetTemp = new TreeSet<DescTWSearchModel>();
        TreeSet<DescCNSearchModel> descCNTreeSetTemp = new TreeSet<DescCNSearchModel>();
        List<StandardDataName> standardDataNameList = this.standardDataNameDao.getDataNameByApprovedStatus(4L, false);
        for (StandardDataName standardDataName : standardDataNameList) {
            DataNameModel model = new DataNameModel(standardDataName.getDataName(), standardDataName.getDescriptionZhTw(), standardDataName.getDescriptionZhCn(), standardDataName.getDescriptionEnUs());
            dataNameTreeSetTemp.add(new DataNameSearchModel(model));
            descTWTreeSetTemp.add(new DescTWSearchModel(model));
            descCNTreeSetTemp.add(new DescCNSearchModel(model));
        }
        dataNameTreeSet = dataNameTreeSetTemp;
        descTWTreeSet = descTWTreeSetTemp;
        descCNTreeSet = descCNTreeSetTemp;
    }

    public void afterPropertiesSet() {
        this.reloadDataNameToTreeSet();
    }
}

