/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import com.digiwin.athena.apimgmt.apiservice.AbstractApiService;
import com.digiwin.athena.apimgmt.dao.ApiMgmtApprovedStatusDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDataNameDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dao.ApimgmtProductDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.enums.ValidateStateEnum;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.ApprovedStatus;
import com.digiwin.athena.apimgmt.model.Product;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.model.StateCode;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DuplicateApiGetService
extends AbstractApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DuplicateApiGetService.class);
    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;
    @Autowired
    ApiMgmtStandardApiDataNameDao standardApiDataNameDao;
    @Autowired
    ApimgmtProductDao productDao;
    @Autowired
    ApiMgmtApprovedStatusDao approvedStatusDao;

    public DuplicateApiGetService() {
        this.jsonSchemaFileName = "duplicate_api_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws Exception {
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        String tUserName = ApiMgmtServiceContextHolder.getUserName();
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        ObjectNode tResponseNode = this.mapper.createObjectNode();
        StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tApiName = tRequestJsonNode.get(ApiAttributeEnum.apiName.toString()).asText();
        String tVersion = tRequestJsonNode.get(ApiAttributeEnum.version.toString()).asText();
        String branch = ApiVersionServiceUtil.getBranchFromVersion(tVersion);
        List<StandardApiVersion> tStandardApiVersionList = this.standardApiVersionDao.fetchApiVersionsByName(tApiName, branch, "");
        ApprovedStatus tDraft = (ApprovedStatus)this.approvedStatusDao.get(1L);
        StandardApiVersion tStandardApiVersion = null;
        for (StandardApiVersion standardApiVersion : tStandardApiVersionList) {
            if (!standardApiVersion.getVersion().equals(tVersion)) continue;
            tStandardApiVersion = standardApiVersion;
        }
        if (tStandardApiVersion != null) {
            String tDataName;
            StandardApi tStandardApi = tStandardApiVersion.getStandardApi();
            String tApiNameResponse = tStandardApi.getName();
            String tApiDescription = null;
            String tApiRemark = null;
            String tApiTag = null;
            String tApiVersionString = tStandardApiVersion.getVersion();
            String tApprovedStatus = null;
            String tEditHistory = tStandardApiVersion.getUpdateHistory();
            String tInvokeType = tStandardApi.getStandardApiSyncType().getNameEnUs();
            String tRequester = tStandardApi.getRequester();
            String tProvider = tStandardApi.getProvider();
            String tPaging = null;
            String tProductType = null;
            Long tStatusId = tStandardApi.getStandardApiCategory().getId();
            String tGroup = null;
            String isBatch = tStandardApi.getIsBatch() != false ? "Y" : "N";
            boolean tIdempotency = tStandardApiVersion.getIdempotency();
            if (tLocale != null) {
                switch (tLocale) {
                    case "zh_CN": {
                        tApprovedStatus = tDraft.getNameZhCn();
                        tApiDescription = tStandardApi.getDescriptionZhCn();
                        tPaging = tStandardApi.getStandardApiPaging().getNameZhCn();
                        tApiRemark = tStandardApi.getRemarkZhCn();
                        tApiTag = tStandardApi.getTagZhCn();
                        tGroup = tStandardApi.getTagZhCn();
                        break;
                    }
                    case "en_US": {
                        tApprovedStatus = tDraft.getNameEnUs();
                        tApiDescription = tStandardApi.getDescriptionEnUs();
                        tPaging = tStandardApi.getStandardApiPaging().getNameEnUs();
                        tApiRemark = tStandardApi.getRemarkEnUs();
                        tApiTag = tStandardApi.getTagEnUs();
                        tGroup = tStandardApi.getTagEnUs();
                        break;
                    }
                    default: {
                        tApprovedStatus = tDraft.getNameZhTw();
                        tApiDescription = tStandardApi.getDescriptionZhTw();
                        tPaging = tStandardApi.getStandardApiPaging().getNameZhTw();
                        tApiRemark = tStandardApi.getRemarkZhTw();
                        tApiTag = tStandardApi.getTagZhTw();
                        tGroup = tStandardApi.getTagZhTw();
                    }
                }
            }
            ObjectNode tApiDescriptionMultilingualNode = this.mapper.createObjectNode();
            tApiDescriptionMultilingualNode.put(LocaleEnum.ZH_TW.getType(), tStandardApi.getDescriptionZhTw());
            tApiDescriptionMultilingualNode.put(LocaleEnum.ZH_CN.getType(), tStandardApi.getDescriptionZhCn());
            tApiDescriptionMultilingualNode.put(LocaleEnum.EN_US.getType(), tStandardApi.getDescriptionEnUs());
            tResponseNode.set(ApiAttributeEnum.apiDescriptionMultilingual.toString(), (JsonNode)tApiDescriptionMultilingualNode);
            ObjectNode tApiRemarkMultilingualNode = this.mapper.createObjectNode();
            tApiRemarkMultilingualNode.put(LocaleEnum.ZH_TW.getType(), tStandardApi.getRemarkZhTw());
            tApiRemarkMultilingualNode.put(LocaleEnum.ZH_CN.getType(), tStandardApi.getRemarkZhCn());
            tApiRemarkMultilingualNode.put(LocaleEnum.EN_US.getType(), tStandardApi.getRemarkEnUs());
            tResponseNode.set(ApiAttributeEnum.apiRemarkMultilingual.toString(), (JsonNode)tApiRemarkMultilingualNode);
            ObjectNode tApiTagMultilingualNode = this.mapper.createObjectNode();
            tApiTagMultilingualNode.put(LocaleEnum.ZH_TW.getType(), tStandardApi.getTagZhTw());
            tApiTagMultilingualNode.put(LocaleEnum.ZH_CN.getType(), tStandardApi.getTagZhCn());
            tApiTagMultilingualNode.put(LocaleEnum.EN_US.getType(), tStandardApi.getTagEnUs());
            tResponseNode.set(ApiAttributeEnum.apiTagMultilingual.toString(), (JsonNode)tApiTagMultilingualNode);
            tResponseNode.put(ApiAttributeEnum.apiName.toString(), tApiNameResponse);
            tResponseNode.put(ApiAttributeEnum.apiDescription.toString(), tApiDescription);
            tResponseNode.put(ApiAttributeEnum.apiRemark.toString(), tApiRemark);
            tResponseNode.put(ApiAttributeEnum.apiTag.toString(), tApiTag);
            tResponseNode.put(ApiAttributeEnum.apiVersion.toString(), tApiVersionString);
            tResponseNode.put(ApiAttributeEnum.applicant.toString(), tUserName);
            tResponseNode.put(ApiAttributeEnum.approvedStatus.toString(), tApprovedStatus);
            tResponseNode.put(ApiAttributeEnum.editHistory.toString(), tEditHistory);
            tResponseNode.put(ApiAttributeEnum.requester.toString(), tRequester);
            tResponseNode.put(ApiAttributeEnum.provider.toString(), tProvider);
            tResponseNode.put(ApiAttributeEnum.idempotency.toString(), tIdempotency);
            tResponseNode.put(ApiAttributeEnum.invokeType.toString(), tInvokeType);
            tResponseNode.put(ApiAttributeEnum.group.toString(), tGroup);
            tResponseNode.put(ApiAttributeEnum.isBatch.toString(), isBatch);
            tResponseNode.put(ApiAttributeEnum.paging.toString(), tPaging);
            tResponseNode.put(ApiAttributeEnum.statusId.toString(), tStatusId);
            ArrayNode tHostProductAryNode = this.mapper.createArrayNode();
            ArrayNode tServiceProductAryNode = this.mapper.createArrayNode();
            String[] tRequesterProducts = tRequester.split(",");
            String[] tProviderProducts = tProvider.split(",");
            for (String tRequesterProduct : tRequesterProducts) {
                tHostProductAryNode.add(tRequesterProduct);
            }
            for (String tProviderProduct : tProviderProducts) {
                tServiceProductAryNode.add(tProviderProduct);
            }
            if (tProviderProducts.length != 0) {
                List<Product> tProducts = this.productDao.getByName(tProviderProducts[0]);
                Product tProduct = null;
                if (tProducts.size() != 0) {
                    tProduct = tProducts.get(0);
                }
                if (tProduct != null && tProduct.getProductCategory() != null) {
                    if (tLocale != null) {
                        switch (tLocale) {
                            case "zh_CN": {
                                tProductType = tProduct.getProductCategory().getNameZhCn();
                                break;
                            }
                            case "en_US": {
                                tProductType = tProduct.getProductCategory().getNameEnUs();
                                break;
                            }
                            default: {
                                tProductType = tProduct.getProductCategory().getNameZhTw();
                            }
                        }
                    }
                    tResponseNode.put(ApiAttributeEnum.productType.toString(), tProductType);
                    ObjectNode tProductTypeMultilingualNode = this.mapper.createObjectNode();
                    tProductTypeMultilingualNode.put(LocaleEnum.ZH_TW.getType(), tProduct.getProductCategory().getNameZhTw());
                    tProductTypeMultilingualNode.put(LocaleEnum.ZH_CN.getType(), tProduct.getProductCategory().getNameZhCn());
                    tProductTypeMultilingualNode.put(LocaleEnum.EN_US.getType(), tProduct.getProductCategory().getNameEnUs());
                    tResponseNode.set(ApiAttributeEnum.productTypeMultilingual.toString(), (JsonNode)tProductTypeMultilingualNode);
                }
            }
            List<StandardApiDataName> tStandardApiDataNameList = this.standardApiDataNameDao.getByApiVerId(tStandardApiVersion.getId(), true);
            ArrayNode tRequestMessageSpecAryNode = this.mapper.createArrayNode();
            tResponseNode.set(ApiAttributeEnum.requestMessageSpec.toString(), (JsonNode)tRequestMessageSpecAryNode);
            for (StandardApiDataName standardApiDataName : tStandardApiDataNameList) {
                if (standardApiDataName.getMsgType() != 1) continue;
                ObjectNode tRequestMessageSpecNode = this.mapper.createObjectNode();
                String tColumnType = standardApiDataName.getColumnType();
                long tId = standardApiDataName.getId();
                boolean tIsDataKey = standardApiDataName.getIsDatakey() != null && standardApiDataName.getIsDatakey() != false;
                boolean tIsRequired = standardApiDataName.getIsRequired() != null && standardApiDataName.getIsRequired() != false;
                boolean tIsArray = standardApiDataName.getIsArray() != null && standardApiDataName.getIsArray() != false;
                boolean tCanSort = standardApiDataName.getCanSort() != null && standardApiDataName.getCanSort() != false;
                boolean tCanFilter = standardApiDataName.getCanFilter() != null && standardApiDataName.getCanFilter() != false;
                boolean tIsBusinessKey = standardApiDataName.getIsBusinesskey() != null && standardApiDataName.getIsBusinesskey() != false;
                String tDataType = standardApiDataName.getDataType();
                String tValue = standardApiDataName.getValue();
                String tListEnum = null;
                if (standardApiDataName.getListEnumZhTw() != null) {
                    tListEnum = MessageFormat.format("zh_TW:[{0}]\nzh_CN:[{1}]\nen_US:[{2}]", standardApiDataName.getListEnumZhTw(), standardApiDataName.getListEnumZhCn(), standardApiDataName.getListEnumEn());
                }
                String tRequestMessageDataNameEditHistory = standardApiDataName.getUpdateHistory();
                ObjectNode tDataNameDescriptionMultilingualNode = this.mapper.createObjectNode();
                tDataNameDescriptionMultilingualNode.put(LocaleEnum.ZH_TW.getType(), standardApiDataName.getDescriptionZhTw());
                tDataNameDescriptionMultilingualNode.put(LocaleEnum.ZH_CN.getType(), standardApiDataName.getDescriptionZhCn());
                tDataNameDescriptionMultilingualNode.put(LocaleEnum.EN_US.getType(), standardApiDataName.getDescriptionEnUs());
                ObjectNode tDataRemarkMultilingualNode = this.mapper.createObjectNode();
                tDataRemarkMultilingualNode.put(LocaleEnum.ZH_TW.getType(), standardApiDataName.getRemarkZhTw());
                tDataRemarkMultilingualNode.put(LocaleEnum.ZH_CN.getType(), standardApiDataName.getRemarkZhCn());
                tDataRemarkMultilingualNode.put(LocaleEnum.EN_US.getType(), standardApiDataName.getRemarkEnUs());
                tDataName = standardApiDataName.getStandardDataName();
                if (standardApiDataName.getParentId() != null) {
                    long tParentId = standardApiDataName.getParentId();
                    tRequestMessageSpecNode.put(ApiAttributeEnum.parent.toString(), tParentId);
                }
                tRequestMessageSpecNode.put(ApiAttributeEnum.columnType.toString(), tColumnType);
                tRequestMessageSpecNode.put(ApiAttributeEnum.id.toString(), tId);
                tRequestMessageSpecNode.put(ApiAttributeEnum.dataName.toString(), tDataName);
                tRequestMessageSpecNode.set(ApiAttributeEnum.dataDescriptionMultilingual.toString(), (JsonNode)tDataNameDescriptionMultilingualNode);
                tRequestMessageSpecNode.set(ApiAttributeEnum.dataNameRemarkMultilingual.toString(), (JsonNode)tDataRemarkMultilingualNode);
                tRequestMessageSpecNode.put(ApiAttributeEnum.isDatakey.toString(), tIsDataKey);
                tRequestMessageSpecNode.put(ApiAttributeEnum.dataType.toString(), tDataType);
                tRequestMessageSpecNode.put(ApiAttributeEnum.canSort.toString(), tCanSort);
                tRequestMessageSpecNode.put(ApiAttributeEnum.canFilter.toString(), tCanFilter);
                tRequestMessageSpecNode.put(ApiAttributeEnum.isRequired.toString(), tIsRequired);
                tRequestMessageSpecNode.put(ApiAttributeEnum.isArray.toString(), tIsArray);
                tRequestMessageSpecNode.put(ApiAttributeEnum.isBusinessKey.toString(), tIsBusinessKey);
                tRequestMessageSpecNode.put(ApiAttributeEnum.value.toString(), tValue);
                tRequestMessageSpecNode.put(ApiAttributeEnum.listEnum.toString(), tListEnum);
                tRequestMessageSpecNode.put(ApiAttributeEnum.editHistory.toString(), tRequestMessageDataNameEditHistory);
                tRequestMessageSpecAryNode.add((JsonNode)tRequestMessageSpecNode);
            }
            ArrayNode tResponseMessageSuccessSpecAryNode = this.mapper.createArrayNode();
            tResponseNode.set(ApiAttributeEnum.responseMessageSuccessSpec.toString(), (JsonNode)tResponseMessageSuccessSpecAryNode);
            for (StandardApiDataName standardApiDataName : tStandardApiDataNameList) {
                if (standardApiDataName.getMsgType() != 2) continue;
                ObjectNode tResponseMessageSucccessSpecNode = this.mapper.createObjectNode();
                String tColumnType = standardApiDataName.getColumnType();
                long tId = standardApiDataName.getId();
                boolean tIsDataKey = standardApiDataName.getIsDatakey() != null && standardApiDataName.getIsDatakey() != false;
                boolean tIsRequired = standardApiDataName.getIsRequired() != null && standardApiDataName.getIsRequired() != false;
                boolean tIsArray = standardApiDataName.getIsArray() != null && standardApiDataName.getIsArray() != false;
                boolean tCanSort = standardApiDataName.getCanSort() != null && standardApiDataName.getCanSort() != false;
                boolean tCanFilter = standardApiDataName.getCanFilter() != null && standardApiDataName.getCanFilter() != false;
                boolean tIsBusinessKey = standardApiDataName.getIsBusinesskey() != null && standardApiDataName.getIsBusinesskey() != false;
                String tDataType = standardApiDataName.getDataType();
                String tValue = standardApiDataName.getValue();
                String tListEnum = null;
                if (standardApiDataName.getListEnumZhTw() != null) {
                    tListEnum = MessageFormat.format("zh_TW:[{0}]\nzh_CN:[{1}]\nen_US:[{2}]", standardApiDataName.getListEnumZhTw(), standardApiDataName.getListEnumZhCn(), standardApiDataName.getListEnumEn());
                }
                String tResponseMessageSucccessDataNameEditHistory = standardApiDataName.getUpdateHistory();
                ObjectNode tDataNameDescriptionMultilingualNode = this.mapper.createObjectNode();
                tDataNameDescriptionMultilingualNode.put(LocaleEnum.ZH_TW.getType(), standardApiDataName.getDescriptionZhTw());
                tDataNameDescriptionMultilingualNode.put(LocaleEnum.ZH_CN.getType(), standardApiDataName.getDescriptionZhCn());
                tDataNameDescriptionMultilingualNode.put(LocaleEnum.EN_US.getType(), standardApiDataName.getDescriptionEnUs());
                ObjectNode tDataRemarkMultilingualNode = this.mapper.createObjectNode();
                tDataRemarkMultilingualNode.put(LocaleEnum.ZH_TW.getType(), standardApiDataName.getRemarkZhTw());
                tDataRemarkMultilingualNode.put(LocaleEnum.ZH_CN.getType(), standardApiDataName.getRemarkZhCn());
                tDataRemarkMultilingualNode.put(LocaleEnum.EN_US.getType(), standardApiDataName.getRemarkEnUs());
                String tDataName2 = standardApiDataName.getStandardDataName();
                if (standardApiDataName.getParentId() != null) {
                    long tParentId = standardApiDataName.getParentId();
                    tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.parent.toString(), tParentId);
                }
                tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.columnType.toString(), tColumnType);
                tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.id.toString(), tId);
                tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.dataName.toString(), tDataName2);
                tResponseMessageSucccessSpecNode.set(ApiAttributeEnum.dataDescriptionMultilingual.toString(), (JsonNode)tDataNameDescriptionMultilingualNode);
                tResponseMessageSucccessSpecNode.set(ApiAttributeEnum.dataNameRemarkMultilingual.toString(), (JsonNode)tDataRemarkMultilingualNode);
                tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.isDatakey.toString(), tIsDataKey);
                tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.dataType.toString(), tDataType);
                tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.canSort.toString(), tCanSort);
                tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.canFilter.toString(), tCanFilter);
                tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.isRequired.toString(), tIsRequired);
                tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.isArray.toString(), tIsArray);
                tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.isBusinessKey.toString(), tIsBusinessKey);
                tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.value.toString(), tValue);
                tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.listEnum.toString(), tListEnum);
                tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.editHistory.toString(), tResponseMessageSucccessDataNameEditHistory);
                tResponseMessageSuccessSpecAryNode.add((JsonNode)tResponseMessageSucccessSpecNode);
            }
            ArrayNode tResponseMessageFailedSpecAryNode = this.mapper.createArrayNode();
            tResponseNode.set(ApiAttributeEnum.responseMessageFailedSpec.toString(), (JsonNode)tResponseMessageFailedSpecAryNode);
            for (StandardApiDataName standardApiDataName : tStandardApiDataNameList) {
                if (standardApiDataName.getMsgType() != 3) continue;
                ObjectNode tResponseMessageFailedSpecNode = this.mapper.createObjectNode();
                String tColumnType = standardApiDataName.getColumnType();
                long tId = standardApiDataName.getId();
                boolean tIsDataKey = standardApiDataName.getIsDatakey() != null && standardApiDataName.getIsDatakey() != false;
                boolean tIsRequired = standardApiDataName.getIsRequired() != null && standardApiDataName.getIsRequired() != false;
                boolean tIsArray = standardApiDataName.getIsArray() != null && standardApiDataName.getIsArray() != false;
                boolean tCanSort = standardApiDataName.getCanSort() != null && standardApiDataName.getCanSort() != false;
                boolean tCanFilter = standardApiDataName.getCanFilter() != null && standardApiDataName.getCanFilter() != false;
                boolean tIsBusinessKey = standardApiDataName.getIsBusinesskey() != null && standardApiDataName.getIsBusinesskey() != false;
                String tDataType = standardApiDataName.getDataType();
                String tValue = standardApiDataName.getValue();
                String tListEnum = null;
                if (standardApiDataName.getListEnumZhTw() != null) {
                    tListEnum = MessageFormat.format("zh_TW:[{0}]\nzh_CN:[{1}]\nen_US:[{2}]", standardApiDataName.getListEnumZhTw(), standardApiDataName.getListEnumZhCn(), standardApiDataName.getListEnumEn());
                }
                String tResponseMessageFailedDataNameEditHistory = standardApiDataName.getUpdateHistory();
                tDataName = standardApiDataName.getStandardDataName();
                ObjectNode tDataNameDescriptionMultilingualNode = this.mapper.createObjectNode();
                tDataNameDescriptionMultilingualNode.put(LocaleEnum.ZH_TW.getType(), standardApiDataName.getDescriptionZhTw());
                tDataNameDescriptionMultilingualNode.put(LocaleEnum.ZH_CN.getType(), standardApiDataName.getDescriptionZhCn());
                tDataNameDescriptionMultilingualNode.put(LocaleEnum.EN_US.getType(), standardApiDataName.getDescriptionEnUs());
                ObjectNode tDataRemarkMultilingualNode = this.mapper.createObjectNode();
                tDataRemarkMultilingualNode.put(LocaleEnum.ZH_TW.getType(), standardApiDataName.getRemarkZhTw());
                tDataRemarkMultilingualNode.put(LocaleEnum.ZH_CN.getType(), standardApiDataName.getRemarkZhCn());
                tDataRemarkMultilingualNode.put(LocaleEnum.EN_US.getType(), standardApiDataName.getRemarkEnUs());
                if (standardApiDataName.getParentId() != null) {
                    long tParentId = standardApiDataName.getParentId();
                    tResponseMessageFailedSpecNode.put(ApiAttributeEnum.parent.toString(), tParentId);
                }
                tResponseMessageFailedSpecNode.put(ApiAttributeEnum.columnType.toString(), tColumnType);
                tResponseMessageFailedSpecNode.put(ApiAttributeEnum.id.toString(), tId);
                tResponseMessageFailedSpecNode.put(ApiAttributeEnum.dataName.toString(), tDataName);
                tResponseMessageFailedSpecNode.set(ApiAttributeEnum.dataDescriptionMultilingual.toString(), (JsonNode)tDataNameDescriptionMultilingualNode);
                tResponseMessageFailedSpecNode.set(ApiAttributeEnum.dataNameRemarkMultilingual.toString(), (JsonNode)tDataRemarkMultilingualNode);
                tResponseMessageFailedSpecNode.put(ApiAttributeEnum.isDatakey.toString(), tIsDataKey);
                tResponseMessageFailedSpecNode.put(ApiAttributeEnum.dataType.toString(), tDataType);
                tResponseMessageFailedSpecNode.put(ApiAttributeEnum.canSort.toString(), tCanSort);
                tResponseMessageFailedSpecNode.put(ApiAttributeEnum.canFilter.toString(), tCanFilter);
                tResponseMessageFailedSpecNode.put(ApiAttributeEnum.isRequired.toString(), tIsRequired);
                tResponseMessageFailedSpecNode.put(ApiAttributeEnum.isArray.toString(), tIsArray);
                tResponseMessageFailedSpecNode.put(ApiAttributeEnum.isBusinessKey.toString(), tIsBusinessKey);
                tResponseMessageFailedSpecNode.put(ApiAttributeEnum.value.toString(), tValue);
                tResponseMessageFailedSpecNode.put(ApiAttributeEnum.listEnum.toString(), tListEnum);
                tResponseMessageFailedSpecNode.put(ApiAttributeEnum.editHistory.toString(), tResponseMessageFailedDataNameEditHistory);
                tResponseMessageFailedSpecAryNode.add((JsonNode)tResponseMessageFailedSpecNode);
            }
        } else {
            tStateCode = this.getStateCode(ValidateStateEnum.API_NAME_VER_NOTFOUND.getCode());
        }
        String tDescription = tStateCode.getDescription();
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, tResponseNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

