/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.model;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.model.ProductApiDataName;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;

@TableName(value="standard_api_data_name", resultMap="BaseResultMap")
public class StandardApiDataName
implements Serializable {
    private static final long serialVersionUID = 1L;
    @TableId(type=IdType.AUTO)
    private Long id;
    @TableField(value="api_ver_id")
    private Long apiVerId;
    @TableField(value="api_ver")
    private String apiVer;
    @TableField(value="column_type")
    @Expose
    private String columnType;
    @TableField(value="data_type")
    private String dataType;
    @TableField(value="msg_type")
    @Expose
    private Integer msgType;
    @Deprecated
    @Expose
    private Boolean nullable;
    @TableField(value="is_required")
    @Expose
    private Boolean isRequired;
    @TableField(value="remark_en_us")
    @Expose
    private String remarkEnUs;
    @TableField(value="remark_zh_cn")
    @Expose
    private String remarkZhCn;
    @TableField(value="remark_zh_tw")
    @Expose
    private String remarkZhTw;
    @TableField(value="description_en_us")
    @Expose
    private String descriptionEnUs;
    @TableField(value="description_zh_cn")
    @Expose
    private String descriptionZhCn;
    @TableField(value="description_zh_tw")
    @Expose
    private String descriptionZhTw;
    @TableField(value="list_enum_zh_tw")
    @Expose
    private String listEnumZhTw;
    @TableField(value="list_enum_zh_cn")
    @Expose
    private String listEnumZhCn;
    @TableField(value="list_enum_en")
    @Expose
    private String listEnumEn;
    @TableField(value="update_history")
    private String updateHistory;
    private String value;
    @TableField(value="is_datakey")
    @Expose
    private Boolean isDatakey;
    @TableField(value="is_array")
    @Expose
    private Boolean isArray;
    @TableField(value="can_sort")
    @Expose
    private Boolean canSort;
    @TableField(value="can_filter")
    @Expose
    private Boolean canFilter;
    @TableField(value="is_businesskey")
    @Expose
    private Boolean isBusinesskey;
    @TableField(exist=false)
    private StandardApiVersion standardApiVersion;
    @TableField(value="parent")
    private Long parentId;
    @TableField(exist=false)
    private StandardApiDataName parent;
    @Expose
    @TableField(exist=false)
    private List<StandardApiDataName> childrens = new ArrayList<StandardApiDataName>();
    @TableField(exist=false)
    private List<ProductApiDataName> productApiDataNames = new ArrayList<ProductApiDataName>();
    @TableField(value="data_name")
    @Expose
    @SerializedName(value="dataName")
    private String standardDataName;

    public void setIsRequired(Boolean isRequired) {
        if (isRequired == null) {
            return;
        }
        this.nullable = isRequired == false;
        this.isRequired = isRequired;
    }

    public static boolean validateName(String apiType, String dataName) {
        if ("openapi".equals(apiType)) {
            return dataName.matches("[a-zA-Z0-9_$]+");
        }
        return dataName.matches("[a-z0-9_]+") || Arrays.asList(ApimgmtConstant.ALLOW_API_DATA_NAME).contains(dataName);
    }

    public void setId(Long id) {
        this.id = id;
        if (this.productApiDataNames != null) {
            this.productApiDataNames.forEach(v -> v.setApiDataName(this));
        }
        if (this.childrens != null) {
            this.childrens.forEach(v -> v.setParent(this));
        }
    }

    public void setParent(StandardApiDataName parent) {
        this.parent = parent;
        if (parent != null) {
            this.parentId = parent.getId();
        }
    }

    public StandardApiDataName addChildren(StandardApiDataName standardApiDataName) {
        this.getChildrens().add(standardApiDataName);
        standardApiDataName.setParent(this);
        standardApiDataName.setStandardApiVersion(this.standardApiVersion);
        return standardApiDataName;
    }

    public ProductApiDataName addProductApiDataName(ProductApiDataName productApiDataName) {
        this.getProductApiDataNames().add(productApiDataName);
        productApiDataName.setApiDataName(this);
        return productApiDataName;
    }

    public void setStandardApiVersion(StandardApiVersion standardApiVersion) {
        this.standardApiVersion = standardApiVersion;
        if (standardApiVersion != null) {
            this.apiVerId = standardApiVersion.getId();
            CollUtil.emptyIfNull(this.childrens).forEach(v -> v.setStandardApiVersion(standardApiVersion));
        }
    }

    public Stream<StandardApiDataName> flatten() {
        return Stream.concat(Stream.of(this), CollUtil.emptyIfNull(this.getChildrens()).stream().flatMap(StandardApiDataName::flatten));
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getApiVerId() {
        return this.apiVerId;
    }

    @Generated
    public String getApiVer() {
        return this.apiVer;
    }

    @Generated
    public String getColumnType() {
        return this.columnType;
    }

    @Generated
    public String getDataType() {
        return this.dataType;
    }

    @Generated
    public Integer getMsgType() {
        return this.msgType;
    }

    @Deprecated
    @Generated
    public Boolean getNullable() {
        return this.nullable;
    }

    @Generated
    public Boolean getIsRequired() {
        return this.isRequired;
    }

    @Generated
    public String getRemarkEnUs() {
        return this.remarkEnUs;
    }

    @Generated
    public String getRemarkZhCn() {
        return this.remarkZhCn;
    }

    @Generated
    public String getRemarkZhTw() {
        return this.remarkZhTw;
    }

    @Generated
    public String getDescriptionEnUs() {
        return this.descriptionEnUs;
    }

    @Generated
    public String getDescriptionZhCn() {
        return this.descriptionZhCn;
    }

    @Generated
    public String getDescriptionZhTw() {
        return this.descriptionZhTw;
    }

    @Generated
    public String getListEnumZhTw() {
        return this.listEnumZhTw;
    }

    @Generated
    public String getListEnumZhCn() {
        return this.listEnumZhCn;
    }

    @Generated
    public String getListEnumEn() {
        return this.listEnumEn;
    }

    @Generated
    public String getUpdateHistory() {
        return this.updateHistory;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public Boolean getIsDatakey() {
        return this.isDatakey;
    }

    @Generated
    public Boolean getIsArray() {
        return this.isArray;
    }

    @Generated
    public Boolean getCanSort() {
        return this.canSort;
    }

    @Generated
    public Boolean getCanFilter() {
        return this.canFilter;
    }

    @Generated
    public Boolean getIsBusinesskey() {
        return this.isBusinesskey;
    }

    @Generated
    public StandardApiVersion getStandardApiVersion() {
        return this.standardApiVersion;
    }

    @Generated
    public Long getParentId() {
        return this.parentId;
    }

    @Generated
    public StandardApiDataName getParent() {
        return this.parent;
    }

    @Generated
    public List<StandardApiDataName> getChildrens() {
        return this.childrens;
    }

    @Generated
    public List<ProductApiDataName> getProductApiDataNames() {
        return this.productApiDataNames;
    }

    @Generated
    public String getStandardDataName() {
        return this.standardDataName;
    }

    @Generated
    public void setApiVerId(Long apiVerId) {
        this.apiVerId = apiVerId;
    }

    @Generated
    public void setApiVer(String apiVer) {
        this.apiVer = apiVer;
    }

    @Generated
    public void setColumnType(String columnType) {
        this.columnType = columnType;
    }

    @Generated
    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    @Generated
    public void setMsgType(Integer msgType) {
        this.msgType = msgType;
    }

    @Deprecated
    @Generated
    public void setNullable(Boolean nullable) {
        this.nullable = nullable;
    }

    @Generated
    public void setRemarkEnUs(String remarkEnUs) {
        this.remarkEnUs = remarkEnUs;
    }

    @Generated
    public void setRemarkZhCn(String remarkZhCn) {
        this.remarkZhCn = remarkZhCn;
    }

    @Generated
    public void setRemarkZhTw(String remarkZhTw) {
        this.remarkZhTw = remarkZhTw;
    }

    @Generated
    public void setDescriptionEnUs(String descriptionEnUs) {
        this.descriptionEnUs = descriptionEnUs;
    }

    @Generated
    public void setDescriptionZhCn(String descriptionZhCn) {
        this.descriptionZhCn = descriptionZhCn;
    }

    @Generated
    public void setDescriptionZhTw(String descriptionZhTw) {
        this.descriptionZhTw = descriptionZhTw;
    }

    @Generated
    public void setListEnumZhTw(String listEnumZhTw) {
        this.listEnumZhTw = listEnumZhTw;
    }

    @Generated
    public void setListEnumZhCn(String listEnumZhCn) {
        this.listEnumZhCn = listEnumZhCn;
    }

    @Generated
    public void setListEnumEn(String listEnumEn) {
        this.listEnumEn = listEnumEn;
    }

    @Generated
    public void setUpdateHistory(String updateHistory) {
        this.updateHistory = updateHistory;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public void setIsDatakey(Boolean isDatakey) {
        this.isDatakey = isDatakey;
    }

    @Generated
    public void setIsArray(Boolean isArray) {
        this.isArray = isArray;
    }

    @Generated
    public void setCanSort(Boolean canSort) {
        this.canSort = canSort;
    }

    @Generated
    public void setCanFilter(Boolean canFilter) {
        this.canFilter = canFilter;
    }

    @Generated
    public void setIsBusinesskey(Boolean isBusinesskey) {
        this.isBusinesskey = isBusinesskey;
    }

    @Generated
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    @Generated
    public void setChildrens(List<StandardApiDataName> childrens) {
        this.childrens = childrens;
    }

    @Generated
    public void setProductApiDataNames(List<ProductApiDataName> productApiDataNames) {
        this.productApiDataNames = productApiDataNames;
    }

    @Generated
    public void setStandardDataName(String standardDataName) {
        this.standardDataName = standardDataName;
    }

    @Generated
    public String toString() {
        return "StandardApiDataName()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StandardApiDataName)) {
            return false;
        }
        StandardApiDataName other = (StandardApiDataName)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$apiVerId = this.getApiVerId();
        Long other$apiVerId = other.getApiVerId();
        if (this$apiVerId == null ? other$apiVerId != null : !((Object)this$apiVerId).equals(other$apiVerId)) {
            return false;
        }
        Integer this$msgType = this.getMsgType();
        Integer other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !((Object)this$msgType).equals(other$msgType)) {
            return false;
        }
        Boolean this$nullable = this.getNullable();
        Boolean other$nullable = other.getNullable();
        if (this$nullable == null ? other$nullable != null : !((Object)this$nullable).equals(other$nullable)) {
            return false;
        }
        Boolean this$isRequired = this.getIsRequired();
        Boolean other$isRequired = other.getIsRequired();
        if (this$isRequired == null ? other$isRequired != null : !((Object)this$isRequired).equals(other$isRequired)) {
            return false;
        }
        Boolean this$isDatakey = this.getIsDatakey();
        Boolean other$isDatakey = other.getIsDatakey();
        if (this$isDatakey == null ? other$isDatakey != null : !((Object)this$isDatakey).equals(other$isDatakey)) {
            return false;
        }
        Boolean this$isArray = this.getIsArray();
        Boolean other$isArray = other.getIsArray();
        if (this$isArray == null ? other$isArray != null : !((Object)this$isArray).equals(other$isArray)) {
            return false;
        }
        Boolean this$canSort = this.getCanSort();
        Boolean other$canSort = other.getCanSort();
        if (this$canSort == null ? other$canSort != null : !((Object)this$canSort).equals(other$canSort)) {
            return false;
        }
        Boolean this$canFilter = this.getCanFilter();
        Boolean other$canFilter = other.getCanFilter();
        if (this$canFilter == null ? other$canFilter != null : !((Object)this$canFilter).equals(other$canFilter)) {
            return false;
        }
        Boolean this$isBusinesskey = this.getIsBusinesskey();
        Boolean other$isBusinesskey = other.getIsBusinesskey();
        if (this$isBusinesskey == null ? other$isBusinesskey != null : !((Object)this$isBusinesskey).equals(other$isBusinesskey)) {
            return false;
        }
        Long this$parentId = this.getParentId();
        Long other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !((Object)this$parentId).equals(other$parentId)) {
            return false;
        }
        String this$apiVer = this.getApiVer();
        String other$apiVer = other.getApiVer();
        if (this$apiVer == null ? other$apiVer != null : !this$apiVer.equals(other$apiVer)) {
            return false;
        }
        String this$columnType = this.getColumnType();
        String other$columnType = other.getColumnType();
        if (this$columnType == null ? other$columnType != null : !this$columnType.equals(other$columnType)) {
            return false;
        }
        String this$dataType = this.getDataType();
        String other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        String this$remarkEnUs = this.getRemarkEnUs();
        String other$remarkEnUs = other.getRemarkEnUs();
        if (this$remarkEnUs == null ? other$remarkEnUs != null : !this$remarkEnUs.equals(other$remarkEnUs)) {
            return false;
        }
        String this$remarkZhCn = this.getRemarkZhCn();
        String other$remarkZhCn = other.getRemarkZhCn();
        if (this$remarkZhCn == null ? other$remarkZhCn != null : !this$remarkZhCn.equals(other$remarkZhCn)) {
            return false;
        }
        String this$remarkZhTw = this.getRemarkZhTw();
        String other$remarkZhTw = other.getRemarkZhTw();
        if (this$remarkZhTw == null ? other$remarkZhTw != null : !this$remarkZhTw.equals(other$remarkZhTw)) {
            return false;
        }
        String this$descriptionEnUs = this.getDescriptionEnUs();
        String other$descriptionEnUs = other.getDescriptionEnUs();
        if (this$descriptionEnUs == null ? other$descriptionEnUs != null : !this$descriptionEnUs.equals(other$descriptionEnUs)) {
            return false;
        }
        String this$descriptionZhCn = this.getDescriptionZhCn();
        String other$descriptionZhCn = other.getDescriptionZhCn();
        if (this$descriptionZhCn == null ? other$descriptionZhCn != null : !this$descriptionZhCn.equals(other$descriptionZhCn)) {
            return false;
        }
        String this$descriptionZhTw = this.getDescriptionZhTw();
        String other$descriptionZhTw = other.getDescriptionZhTw();
        if (this$descriptionZhTw == null ? other$descriptionZhTw != null : !this$descriptionZhTw.equals(other$descriptionZhTw)) {
            return false;
        }
        String this$listEnumZhTw = this.getListEnumZhTw();
        String other$listEnumZhTw = other.getListEnumZhTw();
        if (this$listEnumZhTw == null ? other$listEnumZhTw != null : !this$listEnumZhTw.equals(other$listEnumZhTw)) {
            return false;
        }
        String this$listEnumZhCn = this.getListEnumZhCn();
        String other$listEnumZhCn = other.getListEnumZhCn();
        if (this$listEnumZhCn == null ? other$listEnumZhCn != null : !this$listEnumZhCn.equals(other$listEnumZhCn)) {
            return false;
        }
        String this$listEnumEn = this.getListEnumEn();
        String other$listEnumEn = other.getListEnumEn();
        if (this$listEnumEn == null ? other$listEnumEn != null : !this$listEnumEn.equals(other$listEnumEn)) {
            return false;
        }
        String this$updateHistory = this.getUpdateHistory();
        String other$updateHistory = other.getUpdateHistory();
        if (this$updateHistory == null ? other$updateHistory != null : !this$updateHistory.equals(other$updateHistory)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$standardDataName = this.getStandardDataName();
        String other$standardDataName = other.getStandardDataName();
        return !(this$standardDataName == null ? other$standardDataName != null : !this$standardDataName.equals(other$standardDataName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StandardApiDataName;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $apiVerId = this.getApiVerId();
        result = result * 59 + ($apiVerId == null ? 43 : ((Object)$apiVerId).hashCode());
        Integer $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : ((Object)$msgType).hashCode());
        Boolean $nullable = this.getNullable();
        result = result * 59 + ($nullable == null ? 43 : ((Object)$nullable).hashCode());
        Boolean $isRequired = this.getIsRequired();
        result = result * 59 + ($isRequired == null ? 43 : ((Object)$isRequired).hashCode());
        Boolean $isDatakey = this.getIsDatakey();
        result = result * 59 + ($isDatakey == null ? 43 : ((Object)$isDatakey).hashCode());
        Boolean $isArray = this.getIsArray();
        result = result * 59 + ($isArray == null ? 43 : ((Object)$isArray).hashCode());
        Boolean $canSort = this.getCanSort();
        result = result * 59 + ($canSort == null ? 43 : ((Object)$canSort).hashCode());
        Boolean $canFilter = this.getCanFilter();
        result = result * 59 + ($canFilter == null ? 43 : ((Object)$canFilter).hashCode());
        Boolean $isBusinesskey = this.getIsBusinesskey();
        result = result * 59 + ($isBusinesskey == null ? 43 : ((Object)$isBusinesskey).hashCode());
        Long $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : ((Object)$parentId).hashCode());
        String $apiVer = this.getApiVer();
        result = result * 59 + ($apiVer == null ? 43 : $apiVer.hashCode());
        String $columnType = this.getColumnType();
        result = result * 59 + ($columnType == null ? 43 : $columnType.hashCode());
        String $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        String $remarkEnUs = this.getRemarkEnUs();
        result = result * 59 + ($remarkEnUs == null ? 43 : $remarkEnUs.hashCode());
        String $remarkZhCn = this.getRemarkZhCn();
        result = result * 59 + ($remarkZhCn == null ? 43 : $remarkZhCn.hashCode());
        String $remarkZhTw = this.getRemarkZhTw();
        result = result * 59 + ($remarkZhTw == null ? 43 : $remarkZhTw.hashCode());
        String $descriptionEnUs = this.getDescriptionEnUs();
        result = result * 59 + ($descriptionEnUs == null ? 43 : $descriptionEnUs.hashCode());
        String $descriptionZhCn = this.getDescriptionZhCn();
        result = result * 59 + ($descriptionZhCn == null ? 43 : $descriptionZhCn.hashCode());
        String $descriptionZhTw = this.getDescriptionZhTw();
        result = result * 59 + ($descriptionZhTw == null ? 43 : $descriptionZhTw.hashCode());
        String $listEnumZhTw = this.getListEnumZhTw();
        result = result * 59 + ($listEnumZhTw == null ? 43 : $listEnumZhTw.hashCode());
        String $listEnumZhCn = this.getListEnumZhCn();
        result = result * 59 + ($listEnumZhCn == null ? 43 : $listEnumZhCn.hashCode());
        String $listEnumEn = this.getListEnumEn();
        result = result * 59 + ($listEnumEn == null ? 43 : $listEnumEn.hashCode());
        String $updateHistory = this.getUpdateHistory();
        result = result * 59 + ($updateHistory == null ? 43 : $updateHistory.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $standardDataName = this.getStandardDataName();
        result = result * 59 + ($standardDataName == null ? 43 : $standardDataName.hashCode());
        return result;
    }
}

