/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.services;

import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.digiwin.athena.apimgmt.service.util.StandardApiMessageServiceUtil;
import com.digiwin.athena.apimgmt.service.util.ValidateApiDataNameServiceUtil;
import com.digiwin.athena.apimgmt.util.StandardApiMessageUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class ApiMgmtApiSaveAndReviewVerifyProcessor {
    public void checkListEnum(List<Map<String, String>> pApiDataNameCheckResult, Map<String, StandardApiDataName> pAddDataName) {
        HashMap<String, String> tReqErrorLog = new HashMap<String, String>();
        HashMap<String, String> tResSuccessErrorLog = new HashMap<String, String>();
        HashMap<String, String> tResFailedErrorLog = new HashMap<String, String>();
        Map<Integer, List<StandardApiDataName>> tMsgTypeMap = StandardApiMessageServiceUtil.getMsgTypeMap(pAddDataName);
        List<StandardApiDataName> tAddRequest = tMsgTypeMap.get(1);
        List<StandardApiDataName> tAddResponseSuccess = tMsgTypeMap.get(2);
        List<StandardApiDataName> tAddResponseFailed = tMsgTypeMap.get(3);
        StringBuilder tReqRequiredDataName = ValidateApiDataNameServiceUtil.checkListEnum(tAddRequest);
        StringBuilder tResSuccessRequiredDataName = ValidateApiDataNameServiceUtil.checkListEnum(tAddResponseSuccess);
        StringBuilder tResFailedRequiredDataName = ValidateApiDataNameServiceUtil.checkListEnum(tAddResponseFailed);
        if (!tReqRequiredDataName.toString().equals("")) {
            tReqErrorLog.put("description", "Request\u4fe1\u606f\u5167\u5bb9\u5217\u8209\u503c\u683c\u5f0f\u932f\u8aa4\u5b57\u6bb5\uff1a" + tReqRequiredDataName);
            pApiDataNameCheckResult.add(tReqErrorLog);
        }
        if (!tResSuccessRequiredDataName.toString().equals("")) {
            tResSuccessErrorLog.put("description", "Response success\u4fe1\u606f\u5167\u5bb9\u5217\u8209\u503c\u683c\u5f0f\u932f\u8aa4\u5b57\u6bb5\uff1a" + tResSuccessRequiredDataName);
            pApiDataNameCheckResult.add(tResSuccessErrorLog);
        }
        if (!tResFailedRequiredDataName.toString().equals("")) {
            tResFailedErrorLog.put("description", "Response success\u4fe1\u606f\u5167\u5bb9\u5217\u8209\u503c\u683c\u5f0f\u932f\u8aa4\u5b57\u6bb5\uff1a" + tResFailedRequiredDataName);
            pApiDataNameCheckResult.add(tResFailedErrorLog);
        }
    }

    public void checkDataKey(List<Map<String, String>> pApiDataNameCheckResult, Map<String, StandardApiDataName> pAddDataName) {
        HashMap<String, String> tReqErrorLog = new HashMap<String, String>();
        HashMap<String, String> tResSuccessErrorLog = new HashMap<String, String>();
        HashMap<String, String> tResFailedErrorLog = new HashMap<String, String>();
        Map<Integer, List<StandardApiDataName>> tMsgTypeMap = StandardApiMessageServiceUtil.getMsgTypeMap(pAddDataName);
        List<StandardApiDataName> tAddRequest = tMsgTypeMap.get(1);
        List<StandardApiDataName> tAddResponseSuccess = tMsgTypeMap.get(2);
        List<StandardApiDataName> tAddResponseFailed = tMsgTypeMap.get(3);
        StringBuilder tReqRequiredDataName = ValidateApiDataNameServiceUtil.checkDatakey(tAddRequest);
        StringBuilder tResSuccessRequiredDataName = ValidateApiDataNameServiceUtil.checkDatakey(tAddResponseSuccess);
        StringBuilder tResFailedRequiredDataName = ValidateApiDataNameServiceUtil.checkDatakey(tAddResponseFailed);
        if (!tReqRequiredDataName.toString().equals("")) {
            tReqErrorLog.put("description", "Request\u4fe1\u606f\u5167\u5bb9\u300cdatakey\u300d\u6b04\u4f4d\u4e0d\u53ef\u70baY\u7684\u5b57\u6bb5\uff1a" + tReqRequiredDataName);
            pApiDataNameCheckResult.add(tReqErrorLog);
        }
        if (!tResSuccessRequiredDataName.toString().equals("")) {
            tResSuccessErrorLog.put("description", "Response success\u4fe1\u606f\u5167\u5bb9\u300cdatakey\u300d\u6b04\u4f4d\u4e0d\u53ef\u70baY\u7684\u5b57\u6bb5\uff1a" + tResSuccessRequiredDataName);
            pApiDataNameCheckResult.add(tResSuccessErrorLog);
        }
        if (!tResFailedRequiredDataName.toString().equals("")) {
            tResFailedErrorLog.put("description", "Response success\u4fe1\u606f\u5167\u5bb9\u300cdatakey\u300d\u6b04\u4f4d\u4e0d\u53ef\u70baY\u7684\u5b57\u6bb5\uff1a" + tResFailedRequiredDataName);
            pApiDataNameCheckResult.add(tResFailedErrorLog);
        }
    }

    public void checkRequiredDataName(List<Map<String, String>> pApiDataNameCheckResult, Map<String, StandardApiDataName> pAddDataName) {
        HashMap<String, String> tReqErrorLog = new HashMap<String, String>();
        HashMap<String, String> tResSuccessErrorLog = new HashMap<String, String>();
        HashMap<String, String> tResFailedErrorLog = new HashMap<String, String>();
        StringBuilder tReqRequiredDataName = ValidateApiDataNameServiceUtil.checkRequiredDataName(ApimgmtConstant.REQ_CHECK_REQUIRED_DATA_NAME, ApimgmtConstant.REQ_REQUIRED_DATA_NAME, pAddDataName);
        StringBuilder tResSuccessRequiredDataName = ValidateApiDataNameServiceUtil.checkRequiredDataName(ApimgmtConstant.RES_CHECK_SUCCESS_REQUIRED_DATA_NAME, ApimgmtConstant.RES_SUCCESS_REQUIRED_DATA_NAME, pAddDataName);
        StringBuilder tResFailedRequiredDataName = ValidateApiDataNameServiceUtil.checkRequiredDataName(ApimgmtConstant.RES_CHECK_FAIL_REQUIRED_DATA_NAME, ApimgmtConstant.RES_FAIL_REQUIRED_DATA_NAME, pAddDataName);
        if (!tReqRequiredDataName.toString().equals("")) {
            tReqErrorLog.put("description", "Request\u4fe1\u606f\u5167\u5bb9\u7f3a\u5c11\u5fc5\u8981\u5b57\u6bb5\uff1a" + tReqRequiredDataName);
            pApiDataNameCheckResult.add(tReqErrorLog);
        }
        if (!tResSuccessRequiredDataName.toString().equals("")) {
            tResSuccessErrorLog.put("description", "Response success\u4fe1\u606f\u5167\u5bb9\u7f3a\u5c11\u5fc5\u8981\u5b57\u6bb5\uff1a" + tResSuccessRequiredDataName);
            pApiDataNameCheckResult.add(tResSuccessErrorLog);
        }
        if (!tResFailedRequiredDataName.toString().equals("")) {
            tResFailedErrorLog.put("description", "Response failed\u4fe1\u606f\u5167\u5bb9\u7f3a\u5c11\u5fc5\u8981\u5b57\u6bb5\uff1a" + tResFailedRequiredDataName);
            pApiDataNameCheckResult.add(tResFailedErrorLog);
        }
    }

    public void checkPagingRequiredDataName(List<Map<String, String>> pApiDataNameCheckResult, Map<String, StandardApiDataName> pAddDataName) {
        HashMap<String, String> tReqErrorLog = new HashMap<String, String>();
        HashMap<String, String> tResSuccessErrorLog = new HashMap<String, String>();
        StringBuilder tReqRequiredDataName = ValidateApiDataNameServiceUtil.checkRequiredDataName(ApimgmtConstant.REQ_CHECK_PAGING_REQUIRED_DATA_NAME, ApimgmtConstant.REQ_CHECK_PAGING_DATA_NAME, pAddDataName);
        StringBuilder tResSuccessRequiredDataName = ValidateApiDataNameServiceUtil.checkRequiredDataName(ApimgmtConstant.RES_SUCCESS_CHECK_PAGING_REQUIRED_DATA_NAME, ApimgmtConstant.RES_SUCCESS_CHECK_PAGING_DATA_NAME, pAddDataName);
        if (!tReqRequiredDataName.toString().equals("")) {
            tReqErrorLog.put("description", "Request\u4fe1\u606f\u5167\u5bb9\u7f3a\u5c11\u5fc5\u8981\u5b57\u6bb5\uff1a" + tReqRequiredDataName);
            pApiDataNameCheckResult.add(tReqErrorLog);
        }
        if (!tResSuccessRequiredDataName.toString().equals("")) {
            tResSuccessErrorLog.put("description", "Response success\u4fe1\u606f\u5167\u5bb9\u7f3a\u5c11\u5fc5\u8981\u5b57\u6bb5\uff1a" + tResSuccessRequiredDataName);
            pApiDataNameCheckResult.add(tResSuccessErrorLog);
        }
    }

    public void checkIsArrayCannotBeY(List<Map<String, String>> pApiDataNameCheckResult, Map<String, StandardApiDataName> pAddDataName) {
        HashMap<String, String> tErrorLog = new HashMap<String, String>();
        Map<Integer, List<StandardApiDataName>> tMsgTypeMap2 = StandardApiMessageServiceUtil.getMsgTypeMap(pAddDataName);
        List<StandardApiDataName> tAddRequest = tMsgTypeMap2.get(1);
        List<StandardApiDataName> tAddResponseSuccess = tMsgTypeMap2.get(2);
        List<StandardApiDataName> tAddResponseFailed = tMsgTypeMap2.get(3);
        StringBuilder tReqIsArrayCannotBeY = ValidateApiDataNameServiceUtil.isArrayCannotBeY(tAddRequest);
        StringBuilder tResSuccessIsArrayCannotBeY = ValidateApiDataNameServiceUtil.isArrayCannotBeY(tAddResponseSuccess);
        StringBuilder tResFailedIsArrayCannotBeY = ValidateApiDataNameServiceUtil.isArrayCannotBeY(tAddResponseFailed);
        if (!tReqIsArrayCannotBeY.toString().equals("")) {
            tErrorLog.put("description", "Request\u4fe1\u606f\u5167\u5bb9\u300c\u70ba\u6578\u7d44\u300d\u6b04\u4f4d\u4e0d\u53ef\u70baY\u7684\u5b57\u6bb5\uff1a" + tReqIsArrayCannotBeY);
            pApiDataNameCheckResult.add(tErrorLog);
        }
        if (!tResSuccessIsArrayCannotBeY.toString().equals("")) {
            tErrorLog.put("description", "Response success\u4fe1\u606f\u5167\u5bb9\u300c\u70ba\u6578\u7d44\u300d\u6b04\u4f4d\u4e0d\u53ef\u70baY\u7684\u5b57\u6bb5\uff1a" + tResSuccessIsArrayCannotBeY);
            pApiDataNameCheckResult.add(tErrorLog);
        }
        if (!tResFailedIsArrayCannotBeY.toString().equals("")) {
            tErrorLog.put("description", "Response failed\u4fe1\u606f\u5167\u5bb9\u300c\u70ba\u6578\u7d44\u300d\u6b04\u4f4d\u4e0d\u53ef\u70baY\u7684\u5b57\u6bb5\uff1a" + tResFailedIsArrayCannotBeY);
            pApiDataNameCheckResult.add(tErrorLog);
        }
    }

    public void compareDataName(List<Map<String, String>> pApiDataNameCheckResult, List<StandardApiDataName> pPreviApiDataName, Map<String, StandardApiDataName> pAddDataName) {
        HashMap<String, String> tErrorLog = new HashMap<String, String>();
        Map<Integer, List<StandardApiDataName>> tMsgTypeMap = StandardApiMessageUtil.getMsgTypeMap(pPreviApiDataName);
        List<StandardApiDataName> tPreviRequest = tMsgTypeMap.get(1);
        List<StandardApiDataName> tPreviResponseSuccess = tMsgTypeMap.get(2);
        List<StandardApiDataName> tPreviResponseFailed = tMsgTypeMap.get(3);
        StringBuilder tReqIsArrayDataName = ValidateApiDataNameServiceUtil.checkIsArray(tPreviRequest, pAddDataName);
        StringBuilder tResSuccessIsArrayDataName = ValidateApiDataNameServiceUtil.checkIsArray(tPreviResponseSuccess, pAddDataName);
        StringBuilder tResFailedIsArrayDataName = ValidateApiDataNameServiceUtil.checkIsArray(tPreviResponseFailed, pAddDataName);
        if (!tReqIsArrayDataName.toString().equals("")) {
            tErrorLog.put("description", "Request\u4fe1\u606f\u5167\u5bb9\u300c\u70ba\u6578\u7d44\u300d\u6b04\u4f4d\u4e0d\u53ef\u70baN\u7684\u5b57\u6bb5\uff1a" + tReqIsArrayDataName);
            pApiDataNameCheckResult.add(tErrorLog);
        }
        if (!tResSuccessIsArrayDataName.toString().equals("")) {
            tErrorLog.put("description", "Response success\u4fe1\u606f\u5167\u5bb9\u300c\u70ba\u6578\u7d44\u300d\u6b04\u4f4d\u4e0d\u53ef\u70baN\u7684\u5b57\u6bb5\uff1a" + tResSuccessIsArrayDataName);
            pApiDataNameCheckResult.add(tErrorLog);
        }
        if (!tResFailedIsArrayDataName.toString().equals("")) {
            tErrorLog.put("description", "Response failed\u4fe1\u606f\u5167\u5bb9\u300c\u70ba\u6578\u7d44\u300d\u6b04\u4f4d\u4e0d\u53ef\u70baN\u7684\u5b57\u6bb5\uff1a" + tResFailedIsArrayDataName);
            pApiDataNameCheckResult.add(tErrorLog);
        }
    }
}

