/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.services;

import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ApiMgmtApiVersionService {
    private final ApiMgmtStandardApiDao apiDao;

    public ApiMgmtApiVersionService(ApiMgmtStandardApiDao apiDao) {
        this.apiDao = apiDao;
    }

    public String getPreviousVersion(String pVersion) {
        if (pVersion.equals("1.0")) {
            return "0.9";
        }
        String[] versions = pVersion.split("\\.");
        if (this.judgeNewBranch(pVersion).booleanValue()) {
            return "0.9";
        }
        int version = Integer.parseInt(versions[1]) - 1;
        return versions[0] + "." + version;
    }

    public int getMajorVersion(String version) {
        if (StringUtils.isBlank((CharSequence)version)) {
            return 0;
        }
        try {
            String[] parts = version.split("\\.");
            return parts.length > 0 ? Integer.parseInt(parts[0]) : 0;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Nullable
    public String getPrevBranchByVersion(String version) {
        int majorVersion = Integer.parseInt(version.split("\\.")[0]);
        if (majorVersion > 1) {
            return majorVersion - 1 + ".0";
        }
        return null;
    }

    public String getBranchFromVersion(String pVersion) {
        String[] versions = pVersion.split("\\.");
        return versions[0] + ".0";
    }

    public String getNextVersion(String pVersion) {
        String[] versions = pVersion.split("\\.");
        int version = Integer.parseInt(versions[1]) + 1;
        return versions[0] + "." + version;
    }

    public StandardApiVersion getLatestVersion(List<StandardApiVersion> pStandardApiVersions) {
        Map<Integer, StandardApiVersion> apiVersionMap = pStandardApiVersions.stream().collect(Collectors.toMap(version -> {
            String[] versions = version.getVersion().split("\\.");
            return Integer.parseInt(versions[1]);
        }, data -> data));
        ArrayList<Integer> keys = new ArrayList<Integer>(apiVersionMap.keySet());
        keys.sort(Collections.reverseOrder());
        return apiVersionMap.get(keys.get(0));
    }

    public StandardApiVersion getFirstVersion(List<StandardApiVersion> pStandardApiVersions) {
        Map<Integer, StandardApiVersion> apiVersionMap = pStandardApiVersions.stream().collect(Collectors.toMap(version -> {
            String[] versions = version.getVersion().split("\\.");
            return Integer.parseInt(versions[1]);
        }, data -> data));
        ArrayList<Integer> keys = new ArrayList<Integer>(apiVersionMap.keySet());
        Collections.sort(keys);
        return apiVersionMap.get(keys.get(0));
    }

    public Boolean judgeVersion(String pVersion) {
        return pVersion.matches("\\d+\\.\\d+");
    }

    public Boolean judgeNewBranch(String pVersion) {
        String[] versions = pVersion.split("\\.");
        int minor = Integer.parseInt(versions[1]);
        return minor == 0;
    }
}

