/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.services;

import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.infra.file.ApiMgmtFileService;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMgmtDmcFileService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtDmcFileService.class);
    @Autowired
    private ApiMgmtFileService apiMgmtFileService;

    public void uploadFileAndGenerateDownloadLink(ObjectNode pResponseNode, String pFilePath, String pFileName, boolean pIsDetail, int pFailedNum) throws Exception {
        String tSharedDownloadLink = this.apiMgmtFileService.uploadFileAndGenerateDownloadLink(new File(pFilePath), pFileName);
        if (!StringUtil.isEmptyOrSpace((Object)tSharedDownloadLink)) {
            if (pIsDetail) {
                pResponseNode.put(ApiAttributeEnum.detailFileLink.toString(), tSharedDownloadLink);
                if (pFailedNum != 0) {
                    pResponseNode.put(ApiAttributeEnum.failedNum.toString(), pFailedNum);
                }
            } else {
                pResponseNode.put(ApiAttributeEnum.fileLink.toString(), tSharedDownloadLink);
                pResponseNode.put(ApiAttributeEnum.fileName.toString(), pFileName);
            }
        }
    }

    public String uploadFile(File pFile, String pFileName) throws Exception {
        return this.apiMgmtFileService.uploadFile(pFile, pFileName);
    }

    public String generateShareDownloadLink(String pFileId) throws Exception {
        return this.apiMgmtFileService.generateDownloadLink(pFileId);
    }
}

