/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.services;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProductCategoryDao;
import com.digiwin.athena.apimgmt.model.ProductCategory;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMgmtProductCategoryService
implements InitializingBean {
    private static final Lock LOCK = new ReentrantLock(true);
    private List<ProductCategory> productCategories;
    @Autowired
    private ApiMgmtProductCategoryDao productCategoryDao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProductCategory(String providers) {
        LOCK.lock();
        try {
            if (CollUtil.isNotEmpty(this.productCategories) && StringUtils.isNotBlank((CharSequence)providers)) {
                for (String provider : providers.split(",")) {
                    boolean isExists = false;
                    for (ProductCategory productCategory : this.productCategories) {
                        if (!productCategory.getNameEnUs().equals(provider) && !productCategory.getNameZhCn().equals(provider) && !productCategory.getNameZhTw().equals(provider)) continue;
                        isExists = true;
                        break;
                    }
                    if (isExists) continue;
                    ProductCategory pc = new ProductCategory();
                    pc.setNameEnUs(provider);
                    pc.setNameZhCn(provider);
                    pc.setNameZhTw(provider);
                    this.productCategoryDao.save(pc);
                }
                this.productCategories = this.productCategoryDao.getAll();
            }
        }
        finally {
            LOCK.unlock();
        }
    }

    public void afterPropertiesSet() {
        this.productCategories = this.productCategoryDao.getAll();
    }
}

