/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.services;

import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.enums.APIExportImportEnums;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtProp;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.service.util.StandardApiFileReadServiceUtil;
import com.digiwin.athena.apimgmt.services.ApiMgmtStandardApiSpecAnalyzeService;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="openapi")
public class ApiMgmtStandardOpenApiSpecAnalyzeService
extends ApiMgmtStandardApiSpecAnalyzeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtStandardOpenApiSpecAnalyzeService.class);
    @Autowired
    private ApiMgmtProp prop;

    @Override
    protected void setStandardApiExtend(List<Map<String, String>> tResult, StandardApi pStandardApi, JsonNode pRequestJsonNode, String pLocale) {
        String tApiName = pRequestJsonNode.get(ApiAttributeEnum.apiName.toString()).asText();
        pStandardApi.setName(tApiName);
        if (ApimgmtConstant.PATTERN_OPEN_API_NAME.matcher(tApiName).matches()) {
            if (this.prop.isEnvType()) {
                pStandardApi.setName("dw.paas." + tApiName);
            } else {
                pStandardApi.setName(tApiName);
            }
        } else {
            StandardApiFileReadServiceUtil.uploadCheckResult(tResult, APIExportImportEnums.APINAME_WRONG.toString(), 2L, null, 0, 0, pLocale);
        }
        if (null != pRequestJsonNode.get(ApiAttributeEnum.parentApiName.toString()) && !"null".equals(pRequestJsonNode.get(ApiAttributeEnum.parentApiName.toString()).asText())) {
            StandardApiFileReadServiceUtil.uploadCheckResult(tResult, APIExportImportEnums.APINAME_WRONG.toString(), 40L, null, 0, 0, pLocale);
        }
        String protocol = pRequestJsonNode.get(ApiAttributeEnum.protocol.toString()).asText();
        pStandardApi.setProtocol(protocol);
        String requestMethod = pRequestJsonNode.get(ApiAttributeEnum.requestMethod.toString()).asText();
        pStandardApi.setRequestMethod(requestMethod);
        if (pRequestJsonNode.has(ApiAttributeEnum.apiPath.toString()) && !pRequestJsonNode.get(ApiAttributeEnum.apiPath.toString()).isNull()) {
            String apiPath = pRequestJsonNode.get(ApiAttributeEnum.apiPath.toString()).asText();
            pStandardApi.setApiPath(apiPath);
        }
    }
}

