/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.services;

import cn.hutool.core.util.URLUtil;
import com.digiwin.athena.apimgmt.infra.http.HttpFailedException;
import com.digiwin.athena.apimgmt.infra.http.HttpRequest;
import com.digiwin.athena.apimgmt.infra.util.HttpUtil;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.service.model.ApiVer;
import com.digiwin.athena.apimgmt.service.model.DelApiInfo;
import com.digiwin.athena.apimgmt.service.model.MdcResponse;
import com.digiwin.athena.apimgmt.service.util.DaoServiceUtil;
import com.digiwin.athena.apimgmt.service.util.MailServiceUtil;
import com.google.gson.GsonBuilder;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ApiMgmtSyncMdcDeleteService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtSyncMdcDeleteService.class);

    public void runSyncMdcMetadataDel(List<Long> pListDelApiId, String pSyncUrl, Boolean sendMqJudge, String tUserId, String tToken, String routerKey) {
        DelApiInfo tDelApiInfo = new DelApiInfo();
        if (null != sendMqJudge) {
            tDelApiInfo.setSendMqJudge(sendMqJudge);
        }
        for (Long tDelApiId : pListDelApiId) {
            StandardApiVersion tStandardApiVersion = (StandardApiVersion)DaoServiceUtil.getStandardApiVersionDao().get(tDelApiId);
            StandardApi tStandardApi = tStandardApiVersion.getStandardApi();
            if (tStandardApi.skipSyncMdc()) continue;
            String tApiName = tStandardApi.getName();
            String tTenantId = tStandardApi.getTenantId();
            String tApiVerNum = tStandardApiVersion.getVersion();
            tTenantId = (String)StringUtils.defaultIfBlank((CharSequence)tTenantId, (CharSequence)"");
            ApiVer tApiVer = new ApiVer(tApiName, tTenantId, tApiVerNum);
            tDelApiInfo.getApi_info().add(tApiVer);
        }
        this.runSyncMdcMetadataDel(tDelApiInfo, pSyncUrl, tUserId, tToken, routerKey);
    }

    private void runSyncMdcMetadataDel(DelApiInfo pDelApiInfo, String pSyncUrl, String tUserId, String tToken, String routerKey) {
        String tUrl = URLUtil.completeUrl((String)pSyncUrl, (String)"/restful/standard/mdc/StdApiMetadata/Delete");
        String tStrJsonRequestBody = "";
        int httpStatusCode = -1;
        String tResponseMessage = "";
        try {
            tStrJsonRequestBody = new GsonBuilder().disableHtmlEscaping().create().toJson((Object)pDelApiInfo);
            HttpRequest tHttpPost = HttpRequest.ofPost((String)tUrl);
            tHttpPost.setEntity((Object)tStrJsonRequestBody);
            tHttpPost.setHeader("token", (Object)tToken);
            tHttpPost.setHeader("userId", (Object)tUserId);
            if (null != routerKey) {
                tHttpPost.setHeader("routerKey", (Object)routerKey);
            }
            MdcResponse tMdcResponse = (MdcResponse)HttpUtil.execute((HttpRequest)tHttpPost, MdcResponse.class);
            String tMdcStatCode = tMdcResponse.getExecution().getCode();
            tResponseMessage = tMdcResponse.getExecution().getDescription();
            if (!"000".equals(tMdcStatCode)) {
                String tMailContent = MessageFormat.format("<HTML><BODY>{0} {1}<BR>{2}<BR><BR><BR>\u8acb\u6c42MDC url: {3}<BR>request message body: {4}<BR>HTTP\u72c0\u614b\u78bc: {5}<BR>MDC\u56de\u61c9\u7684\u8a0a\u606f: {6}</BODY></HTML>", "\u540c\u6b65API\u5143\u6578\u64da\u81f3MDC\uff0c\u540c\u6b65\u522a\u9664\u5931\u6557.", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime()), this.genDelApiDataInfoStr(pDelApiInfo), tUrl, tStrJsonRequestBody, httpStatusCode, tResponseMessage);
                MailServiceUtil.sendMailToAdmin(tMailContent, "\u540c\u6b65API\u5143\u6578\u64da\u81f3MDC\uff0c\u540c\u6b65\u522a\u9664\u5931\u6557.");
            }
        }
        catch (Exception e) {
            if (e instanceof HttpFailedException) {
                httpStatusCode = ((HttpFailedException)e).getStatusCode();
                tResponseMessage = ((HttpFailedException)e).getRespBody();
            } else {
                httpStatusCode = 500;
                tResponseMessage = e.getMessage();
            }
            String tMailContent = MessageFormat.format("<HTML><BODY>{0} {1}<BR>{2}<BR><BR><BR>\u8acb\u6c42MDC url: {3}<BR>request message body: {4}<BR>HTTP\u72c0\u614b\u78bc: {5}<BR>MDC\u56de\u61c9\u7684\u8a0a\u606f: {6}</BODY></HTML>", "\u540c\u6b65API\u5143\u6578\u64da\u81f3MDC\uff0c\u540c\u6b65\u522a\u9664\u5931\u6557.", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime()), this.genDelApiDataInfoStr(pDelApiInfo), tUrl, tStrJsonRequestBody, httpStatusCode, tResponseMessage);
            MailServiceUtil.sendMailToAdmin(tMailContent, "\u540c\u6b65API\u5143\u6578\u64da\u81f3MDC\uff0c\u540c\u6b65\u522a\u9664\u5931\u6557.");
        }
    }

    private String genDelApiDataInfoStr(DelApiInfo pDelApiInfo) {
        String tStr = "";
        try {
            for (ApiVer tDelApiVer : pDelApiInfo.getApi_info()) {
                String tApiName = tDelApiVer.getName();
                String tApiVer = tDelApiVer.getVersion();
                String tTenantId = tDelApiVer.getTenant_id();
                tStr = MessageFormat.format("{0}{1}API\u540d\u7a31: {2}, API\u7248\u672c: {3}, \u79df\u6236ID: {4}", tStr, "<BR>", tApiName, tApiVer, tTenantId);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return tStr;
    }
}

