/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.services;

import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMgmtValidateApiDataNameService {
    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;

    public StringBuilder checkApiIsLackDataName(List<StandardApiDataName> pPreviApiDataName, Map<String, StandardApiDataName> pAddDataName) {
        StringBuilder tLackDataName = new StringBuilder();
        for (StandardApiDataName tStandardApiDataName : pPreviApiDataName) {
            String tParentDataName;
            String tColumnType = tStandardApiDataName.getColumnType();
            String tDataName = tStandardApiDataName.getStandardDataName();
            String tDataType = tStandardApiDataName.getMsgType().toString();
            StandardApiDataName tParent = tStandardApiDataName.getParent();
            String string = tParentDataName = tParent == null ? "" : tParent.getStandardDataName();
            StandardApiDataName tDataNameisExist = pAddDataName.get(tColumnType + tDataName + tDataType + tParentDataName);
            if (tDataNameisExist != null) continue;
            this.resultStringBuilder(tLackDataName, tDataName);
        }
        return tLackDataName;
    }

    public StringBuilder checkIsArray(List<StandardApiDataName> pPreviousApiDataName, Map<String, StandardApiDataName> pAddDataName) {
        StringBuilder tIsArrayDataName = new StringBuilder();
        for (StandardApiDataName tApiDataName : pPreviousApiDataName) {
            boolean tApiDataNameIsArray;
            String tParentDataName;
            String tColumnType = tApiDataName.getColumnType();
            boolean tIsArray = tApiDataName.getIsArray();
            if (!tIsArray) continue;
            String tDataName = tApiDataName.getStandardDataName();
            String tDataType = tApiDataName.getMsgType().toString();
            StandardApiDataName tParent = tApiDataName.getParent();
            String string = tParentDataName = tParent == null ? "" : tParent.getStandardDataName();
            StandardApiDataName tStandardApiDataName = pAddDataName.get(tColumnType + tDataName + tDataType + tParentDataName);
            if (tStandardApiDataName == null || (tApiDataNameIsArray = tStandardApiDataName.getIsArray().booleanValue())) continue;
            this.resultStringBuilder(tIsArrayDataName, tDataName);
        }
        return tIsArrayDataName;
    }

    public StringBuilder isArrayCannotBeY(List<StandardApiDataName> pAddDataNameList) {
        StringBuilder tIsArrayCannotBeY = new StringBuilder();
        for (StandardApiDataName tAddDataName : pAddDataNameList) {
            if (!tAddDataName.getIsArray().booleanValue()) continue;
            String tDataName = tAddDataName.getStandardDataName();
            String tColumnType = tAddDataName.getColumnType();
            if (!Arrays.asList(ApimgmtConstant.NOT_ALLOW_ARRAY_COLUMN_TYPE).contains(tColumnType.toUpperCase())) continue;
            this.resultStringBuilder(tIsArrayCannotBeY, tDataName);
        }
        return tIsArrayCannotBeY;
    }

    public StringBuilder checkIsRequired(Map<String, StandardApiDataName> pPreviApiDataNameMap, List<StandardApiDataName> pAddDataName) {
        StringBuilder tCannotIsRequired = new StringBuilder();
        for (StandardApiDataName tRequest : pAddDataName) {
            boolean tIsRequired = tRequest.getIsRequired();
            if (!tIsRequired) continue;
            String tColumnType = tRequest.getColumnType();
            String tDataName = tRequest.getStandardDataName();
            String tDataType = tRequest.getMsgType().toString();
            StandardApiDataName tParent = tRequest.getParent();
            String tParentDataName = tParent == null ? "" : tParent.getStandardDataName();
            StandardApiDataName tPreviApiDataName = pPreviApiDataNameMap.get(tColumnType + tDataName + tDataType + tParentDataName);
            if (tPreviApiDataName != null) {
                boolean tPreviIsRequired = tPreviApiDataName.getIsRequired();
                if (tPreviIsRequired) continue;
                this.resultStringBuilder(tCannotIsRequired, tDataName);
                continue;
            }
            this.resultStringBuilder(tCannotIsRequired, tDataName);
        }
        return tCannotIsRequired;
    }

    public boolean checkBatchIsChanged(boolean pPreviIsBatch, boolean pIsBatch) {
        return pPreviIsBatch != pIsBatch;
    }

    public boolean checkSyncTypeIsChanged(long pPreviSyncType, long pSyncType) {
        return pPreviSyncType != pSyncType;
    }

    public StringBuilder checkRequiredDataName(String[] pCheckRequiredDataName, String[] pRequiredDataName, Map<String, StandardApiDataName> pAddDataName) {
        StringBuilder tRequired = new StringBuilder();
        for (int i = pCheckRequiredDataName.length - 1; i >= 0; --i) {
            if (pAddDataName.get(pCheckRequiredDataName[i]) != null) continue;
            this.resultStringBuilder(tRequired, pRequiredDataName[i]);
        }
        return tRequired;
    }

    private void resultStringBuilder(StringBuilder pStringBuilder, String pDataName) {
        if (pStringBuilder.toString().equals("")) {
            pStringBuilder.append(pDataName);
        } else {
            pStringBuilder.append(",").append(pDataName);
        }
    }

    public StringBuilder checkListEnum(List<StandardApiDataName> pStandardApiDataNameList) {
        StringBuilder tListEnumWrongFormat = new StringBuilder();
        for (StandardApiDataName tStandardApiDataName : pStandardApiDataNameList) {
            String tStrLi;
            String tDataName = tStandardApiDataName.getStandardDataName();
            String tListEnumZhTw = tStandardApiDataName.getListEnumZhTw();
            String tListEnumZhCN = tStandardApiDataName.getListEnumZhCn();
            String tListEnumEnUS = tStandardApiDataName.getListEnumEn();
            if (tListEnumZhTw == null && tListEnumZhCN == null && tListEnumEnUS == null || (tStrLi = MessageFormat.format("zh_TW:[{0}]\nzh_CN:[{1}]\nen_US:[{2}]", tListEnumZhTw, tListEnumZhCN, tListEnumEnUS)).matches("zh_TW:\\[([^.;\\[\\]]+(\\.[^.;\\[\\]]+)+)(;[^.;\\[\\]]+(\\.[^.;\\[\\]]+)+)*\\][\\t\\n\\r\\s]*zh_CN:\\[([^.;\\[\\]]+(\\.[^.;\\[\\]]+)+)(;[^.;\\[\\]]+(\\.[^.;\\[\\]]+)+)*\\][\\t\\n\\r\\s]*en_US:\\[([^.;\\[\\]]+(\\.[^.;\\[\\]]+)+)(;[^.;\\[\\]]+(\\.[^.;\\[\\]]+)+)*\\]")) continue;
            this.resultStringBuilder(tListEnumWrongFormat, tDataName);
        }
        return tListEnumWrongFormat;
    }

    public StringBuilder checkDatakey(List<StandardApiDataName> pStandardApiDataNameList) {
        StringBuilder tListEnumWrongFormat = new StringBuilder();
        for (StandardApiDataName tStandardApiDataName : pStandardApiDataNameList) {
            String tDataName = tStandardApiDataName.getStandardDataName();
            String tColumnType = tStandardApiDataName.getColumnType();
            boolean tDatakey = tStandardApiDataName.getIsDatakey();
            if (tColumnType.endsWith("F") || tColumnType.equals("P") || !tDatakey) continue;
            this.resultStringBuilder(tListEnumWrongFormat, tDataName);
        }
        return tListEnumWrongFormat;
    }
}

