/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.util;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.digiwin.athena.apimgmt.common.model.dto.FileDto;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.NoSuchElementException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

public class ExcelUtil {
    public static void setHeader(HttpServletResponse response, String exportFileName) {
        response.setHeader("content-type", "application/octet-stream");
        response.setContentType("application/octet-stream");
        response.setCharacterEncoding("utf-8");
        try {
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(exportFileName, "UTF-8") + ".xlsx");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static <T> ExcelImportResult<T> importExcel(FileDto file, ImportParams params, Class<T> pojoClass) {
        ExcelImportResult result;
        if (file == null) {
            return null;
        }
        try {
            result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), pojoClass, (ImportParams)params);
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("excel\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("excel\u6587\u4ef6\u5355\u5143\u683c\uff0c" + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new RuntimeException("excel\u6587\u4ef6\u5355\u5143\u683c" + e.getMessage().replace("Invalid CellReference: ", "") + "\u683c\u5f0f\u5f02\u5e38\uff01");
        }
        catch (InvalidFormatException e) {
            throw new RuntimeException("\u8bf7\u4f7f\u7528\u6b63\u786e\u672a\u52a0\u5bc6\u6a21\u677f\u5bfc\u5165\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        return result;
    }
}

