package com.digiwin.athena.apimgmt.common.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import lombok.Getter;
import lombok.Setter;

import java.io.IOException;

public class JacksonJsonSerializer implements com.digiwin.athena.apimgmt.common.json.JsonSerializer {
    @Getter
    @Setter
    private static ObjectMapper objectMapper;

    static {
        SimpleModule module = new SimpleModule();
        module.addSerializer(JsonObject.class, new JsonObjectSerializer());
        module.addSerializer(JsonElement.class, new JsonElementSerializer());

        objectMapper = new ObjectMapper();
        objectMapper.registerModule(module);
    }

    @Override
    public <T> T deserialize(String json, Class<T> clazz) {
        try {
            return objectMapper.readValue(json, clazz);
        } catch (JsonProcessingException e) {
            throw new IllegalArgumentException("json反序列化异常！", e);
        }
    }

    @Override
    public <T> T deserialize(String json, Class<?> clazz, Class<?>... genericClass) {
        try {
            JavaType javaType = objectMapper.getTypeFactory().constructParametricType(clazz, genericClass);
            return objectMapper.readValue(json, javaType);
        } catch (JsonProcessingException e) {
            throw new IllegalArgumentException("json反序列化异常！", e);
        }
    }


    @Override
    public <T> T deserialize(String json, TypeReference<T> typeReference) {
        try {
            return objectMapper.readValue(json, typeReference.toJackson());
        } catch (JsonProcessingException e) {
            throw new IllegalArgumentException("json反序列化异常！", e);
        }
    }

    @Override
    public String serialize(Object obj) {
        try {
            return objectMapper.writeValueAsString(obj);
        } catch (JsonProcessingException e) {
            throw new IllegalArgumentException("json序列化异常！", e);
        }
    }



    static class JsonObjectSerializer extends JsonSerializer<JsonObject> {
        @Override
        public void serialize(JsonObject value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeRawValue(value.toString());
        }
    }

    static class JsonElementSerializer extends JsonSerializer<JsonElement> {
        @Override
        public void serialize(JsonElement value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeRawValue(value.toString());
        }
    }
}
