package com.digiwin.athena.apimgmt.common.json;

public interface JsonSerializer {

    <T> T deserialize(String json, Class<T> clazz);

    /**
     *
     * 泛型反序列化
     * <br/>
     * {@code Result<String,Integer> r = deserialize("{}", Result.class, String.class, Integer.class) }
     *
     * @param clazz        类型
     * @param genericClass 泛型类
     * @return 对象
     */
    <T> T deserialize(String json, Class<?> clazz, Class<?>... genericClass);

    /**
     *
     * 泛型反序列化
     * <br/>
     * {@code Result<String,Integer> r = deserialize("{}", Result.class, String.class, Integer.class) }
     *
     * @param typeReference 类型
     * @return 对象
     */
    <T> T deserialize(String json, TypeReference<T> typeReference);

    String serialize(Object obj);
}
