package com.digiwin.athena.apimgmt.constants;

import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
public class ApiTypeConstants {

	public final static String EMPTY = "";

	/* Name */
	public final static String ESP_NAME = "平臺規範API";

	public final static String OPENAPI_NAME = "集成開放API";

	/* Code */
	public final static String ESP_CODE = "esp";

	public final static String OPENAPI_CODE = "openapi";

    public final static String DEFAULT_CODE = ESP_CODE;

	public final static String[] API_TYPE_ARRAY = {ESP_NAME, OPENAPI_NAME};

	public static  Map<String, List<Map<String, String>>> LANG_OPTIONS = new HashMap<>();

	static {
		List<Map<String, String>> options =new ArrayList<>();
		Map<String, String> map = new HashMap<>();
		map.put(ApimgmtConstant.ID, ESP_CODE);
		map.put(ApimgmtConstant.NAME, "平台规范API");
		options.add(map);
		map = new HashMap<>();
		map.put(ApimgmtConstant.ID, OPENAPI_CODE);
		map.put(ApimgmtConstant.NAME, "集成开放API");
		options.add(map);
		LANG_OPTIONS.put(ApimgmtConstant.ZH_CN, options);

		options =new ArrayList<>();
		map = new HashMap<>();
		map.put(ApimgmtConstant.ID, ESP_CODE);
		map.put(ApimgmtConstant.NAME, "平臺規範API");
		options.add(map);
		map = new HashMap<>();
		map.put(ApimgmtConstant.ID, OPENAPI_CODE);
		map.put(ApimgmtConstant.NAME, "集成開放API");
		options.add(map);
		LANG_OPTIONS.put(ApimgmtConstant.ZH_TW, options);


		options =new ArrayList<>();
		map = new HashMap<>();
		map.put(ApimgmtConstant.ID, ESP_CODE);
		map.put(ApimgmtConstant.NAME, "ESP API");
		options.add(map);
		map = new HashMap<>();
		map.put(ApimgmtConstant.ID, OPENAPI_CODE);
		map.put(ApimgmtConstant.NAME, "OpenApi");
		options.add(map);
		LANG_OPTIONS.put(ApimgmtConstant.EN_US, options);
	}

	public static String getCodeByName(String pName) {
		String tReturn;
		switch (pName) {
		case ESP_NAME:
			tReturn = ESP_CODE;
			break;
		case OPENAPI_NAME:
			tReturn = OPENAPI_CODE;
			break;
		default:
			tReturn = ESP_NAME;
			log.error("Invalid Sync Type Name: " + pName);
		}
		return tReturn;
	}

	public static String getNameByCode(String pCode) {
		String tReturn;
		if (ESP_CODE.equals(pCode)) {
			tReturn = ESP_NAME;
		} else if (OPENAPI_CODE.equals(pCode)) {
			tReturn = OPENAPI_NAME;
		} else {
			tReturn = EMPTY;
			log.error("Invalid Sync Type Code: " + pCode);
		}
		return tReturn;
	}


}
