package com.digiwin.athena.apimgmt.constants;

import java.util.regex.Pattern;

/**
 * 常用常量
 */
public class ApimgmtConstant {

    /**
     * 名称
     */
    public static final String NAME = "name";

    /**
     * 版本
     */
    public static final String VERSION = "version";

    /**
     * 审批状态
     */
    public static final String APPROVED_STATUS = "approvedStatus";

    /**
     * 审批编码
     */
    public static final String APPROVED_STATUS_CODE = "approvedStatusCode";

    /**
     * 描述
     */
    public static final String DESCRIPTION = "description";

    /**
     * 位置
     */
    public static final String SOLUTION = "solution";

    /**
     * 备注
     */
    public static final String REMARK = "remark";

    /**
     * 同步类型
     */
    public static final String SYNC_TYPE = "syncType";

    /**
     * 状态Id
     */
    public static final String STATUS_ID = "statusId";

    /**
     * 验证信息
     */
    public static final String VERIFY_ACCT = "verifyAcct";

    /**
     * 类别
     */
    public static final String CATEGORY = "category";

    /**
     * 类别Id
     */
    public static final String CATEGORY_ID = "categoryId";

    /**
     * 类别名称
     */
    public static final String CATEGORY_NAME = "categoryName";

    /**
     * msg格式
     */
    public static final String MSG_FORMAT = "msgFormat";

    /**
     * 提供者
     */
    public static final String PROVIDER = "provider";

    /**
     * 租户Id
     */
    public static final String TENANT_ID = "tenantId";
    /**
     * 租户Id
     */
    public static final String TENANT_NAME = "tenantName";

    /**
     * package_name
     */
    public static final String PACKAGE_NAME = "package_name";

    /**
     * api创建者
     */
    public static final String API_BUILD_ACCT = "apiBuildAcct";

    /**
     * api创建者
     */
    public static final String API_BUILD_NAME = "apiBuildName";

    /**
     * api创建时间
     */
    public static final String API_BUILD_TIME = "apiBuildTime";

    /**
     * api创建时间 eq
     */
    public static final String API_BUILD_TIME_EQ = "apiBuildTime_eq";

    /**
     * id
     */
    public static final String ID = "id";

    /**
     * 状态
     */
    public static final String STATUS = "status";

    /**
     * 个数
     */
    public static final String COUNT = "count";

    /**
     * 条件列表
     */
    public static final String CONDITION_LIST = "conditionList";

    /**
     * 快捷搜索
     */
    public static final String SIMPLE_CONDITION_LIST = "simpleConditionList";

    /**
     * 条件
     */
    public static final String CONDITION = "condition";

    /**
     * 排序
     */
    public static final String ORDER = "order";

    /**
     * 括号
     */
    public static final String BRACKET = "bracket";

    /**
     * 符号
     */
    public static final String EQUATION = "equation";

    /**
     * 标识
     */
    public static final String MARK = "mark";

    /**
     * 等于
     */
    public static final String EQUAL = "equal";

    /**
     * 包含
     */
    public static final String LIKE = "like";
    public static final String IS = "is";

    /**
     * 选项
     */
    public static final String OPTION = "option";

    /**
     * 内容
     */
    public static final String CONTENT = "content";

    /**
     * api名称
     */
    public static final String API_NAME = "apiName";

    /**
     * api类型
     */
    public static final String API_TYPE = "apiType";

    /**
     * api路径
     */
    public static final String API_PATH = "apiPath";

    /**
     * api类型名称
     */
    public static final String API_TYPE_NAME = "apiTypeName";

    /**
     * api分支
     */
    public static final String API_BRANCH = "branch";

    /**
     * 产品ID
     */
    public static final String PROJECT_ID = "projectId";

    /**
     * 产品名称（英文）
     */
    public static final String PROJECT_NAME = "projectName";
    /**
     * 产品描述(中文)
     */
    public static final String PROJECT_DESC = "projectDesc";

    public static final String PROJECT_HAS_VERSIONS = "hasVersions";

    /**
     * 产品英文名，在表中为project_name
     */
    public static final String PROJECT_CODE = "projectCode";

    /**
     * 产品英文名，在表中为project_name
     */
    public static final String PROJECT_CODE_EQ = "projectCode_eq";
    /**
     * 产品版本ID
     */
    public static final String PROJECT_VERSION_ID = "projectVersionId";

    /**
     * 产品版本名称
     */
    public static final String PROJECT_VERSION_NAME_LIST = "projectVersionNameList";

    /**
     * 产品版本名称(字符串)
     */
    public static final String PROJECT_VERSION_NAME_LIST_STR = "projectVersionNameListStr";

    /**
     * api名称
     */
    public static final String API_NAME_DP = "api_name";

    /**
     * api标签
     */
    public static final String API_TAG = "apiTag";

    /**
     * api数据名称
     */
    public static final String API_DATANAME = "apiDataName";

    /**
     * api描述
     */
    public static final String API_DESC = "apiDescription";

    /**
     * api备注
     */
    public static final String API_REMARK = "apiRemark";

    /**
     * api类目
     */
    public static final String API_CATEGORY = "apiCategory";

    /**
     * api同步类型
     */
    public static final String API_SYNC_TYPE = "apiSyncType";

    /**
     * api状态
     */
    public static final String API_STATUS = "apiStatus";

    /**
     * 用户Id
     */
    public static final String USER_ID = "userId";

    /**
     * 租户
     */
    public static final String TENANT = "tenant";

    /**
     * API名称等于
     */
    public static final String API_NAME_EQ = "apiName_eq";

    /**
     * API标签等于
     */
    public static final String API_TAG_EQ = "apiTag_eq";

    /**
     * API类型等于
     */
    public static final String API_TYPE_EQ = "apiType_eq";

    /**
     * API分支等于
     */
    public static final String API_BRANCH_EQ = "branch_eq";

    /**
     * API数据名称等于
     */
    public static final String API_DATANAME_EQ = "apiDataName_eq";

    /**
     * API描述等于
     */
    public static final String API_DESC_EQ = "apiDescription_eq";

    /**
     * API备注等于
     */
    public static final String API_REMARK_EQ = "apiRemark_eq";

    /**
     * 租户Id等于
     */
    public static final String TENANT_ID_EQ = "tenantId_eq";

    /**
     * zh_TW
     */
    public static final String ZH_TW = "zh_TW";

    /**
     * zh_CN
     */
    public static final String ZH_CN = "zh_CN";

    /**
     * en_US
     */
    public static final String EN_US = "en_US";

    /**
     * token
     */
    public static final String TOKEN = "token";

    /**
     * routerKey
     */
    public static final String ROUTER_KEY = "routerKey";

    /**
     * digi-middleware-auth-app
     */
    public final static String DIGI_MIDDLEWARE_AUTH_APP = "digi-middleware-auth-app";

    /**
     * digi-middleware-auth-user
     */
    public final static String DIGI_MIDDLEWARE_AUTH_USER = "digi-middleware-auth-user";

    /**
     * 取消從應用夥伴們匯入的excel中匯入詞彙的功能。改為若sheet名稱為"辭彙清單_審核1"則匯入詞彙，方便esp自己人導入詞彙至apimgmt中
     */
    public static final String SHEET_DATA_NAME = "辭彙清單_審核1";

    /**
     * API名称正则
     */
    public static final String REGEX_API_NAME = "[a-z0-9_\\.]+";
    public static final Pattern PATTERN_API_NAME = Pattern.compile(REGEX_API_NAME);

    /**
     * API名称正则（集成开发API名称）
     */
    public static final Pattern PATTERN_OPEN_API_NAME = Pattern.compile("[a-zA-Z0-9_.]+");

    /**
     * OpenAPI名称正则
     */
    public static final String REGEX_OPENAPI_NAME = "^/(?:[A-Za-z0-9._~!$&'()*+,;=:@-]|%[0-9A-Fa-f]{2})+(?:/(?:[A-Za-z0-9._~!$&'()*+,;=:@-]|%[0-9A-Fa-f]{2})+)*$";

    // 匹配非法字符（注意这里是逐字符匹配，不考虑%编码合法性）
    public static final Pattern OPENAPI_ILLEGAL_CHAR_PATTERN = Pattern.compile(
            "[^A-Za-z0-9._~!$&'()*+,;=:@/%-]"
    );


    /**
     * 空格
     */
    public static final String BLANK = " ";

    /**
     * apiList
     */
    public static final String API_LIST = "apiList";

    /**
     * code
     */
    public static final String CODE = "code";

    /**
     * 描述
     */
    public static final String DESC = "description";

    /**
     * result
     */
    public static final String RESULT = "result";

    /**
     * success
     */
    public static final String SUCCESS = "success";

    /**
     * 必要字段(用於外顯)，索引順序需和上面的必要字段一致
     */
    public static final String[] REQ_REQUIRED_DATA_NAME = new String[]{};

    public static final String[] RES_SUCCESS_REQUIRED_DATA_NAME = new String[]{"code", "sql_code", "description"};

    public static final String[] RES_FAIL_REQUIRED_DATA_NAME = new String[]{"code", "sql_code", "description"};

    /**
     * 必要字段(用於檢查字段是否存在)
     */
    public static final String[] REQ_CHECK_PAGING_REQUIRED_DATA_NAME = new String[]{"Puse_has_next1", "Ppage_size1", "Ppage_no1"};

    public static final String[] RES_SUCCESS_CHECK_PAGING_REQUIRED_DATA_NAME = new String[]{"Ptotal_results2", "Phas_next2"};

    public static final String[] REQ_CHECK_PAGING_DATA_NAME = new String[]{"use_has_next", "page_size", "page_no"};

    public static final String[] RES_SUCCESS_CHECK_PAGING_DATA_NAME = new String[]{"total_results", "has_next"};

    public static final String[] REQ_CHECK_REQUIRED_DATA_NAME = new String[]{};

    public static final String[] RES_CHECK_SUCCESS_REQUIRED_DATA_NAME = new String[]{"Ecode2", "Esql_code2", "Edescription2"};

    public static final String[] RES_CHECK_FAIL_REQUIRED_DATA_NAME = new String[]{"Ecode3", "Esql_code3", "Edescription3"};

    /**
     * passDesc
     */
    public static final String PASS_DESC = "passDesc";

    /**
     * paas区API前缀
     */
    public static final String API_PAAS_REGEX = "dw.paas.";

    /**
     * 分隔符
     */
    public static final String SPACE = "[ |　]";

    /**
     * Y
     */
    public static final String YES = "Y";

    /**
     * apiVersion
     */
    public static final String API_VERSION = "apiVersion";

    /**
     * apiVersion
     */
    public static final String API_VERSION_DP = "api_version";

    /**
     * 请求者
     */
    public static final String REQUESTER = "requester";

    /**
     * isBatch
     */
    public static final String IS_BATCH = "isBatch";

    /**
     * 请求描述
     */
    public static final String REQ_SPEC = "requestMessageSpec";

    /**
     * 返回成功描述
     */
    public static final String RES_SUCCESS_SPEC = "responseMessageSuccessSpec";

    /**
     * 返回失败描述
     */
    public static final String RES_FAIL_SPEC = "responseMessageFailedSpec";

    /**
     * 类型
     */
    public static final String COLUMN_TYPE = "columnType";

    /**
     * 数据名称
     */
    public static final String DATA_NAME = "dataName";

    /**
     * 描述
     */
    public static final String DATA_DESC_MULT = "dataDescriptionMultilingual";

    /**
     * 主数据
     */
    public static final String IS_DATAKEY = "isDatakey";

    /**
     * 数据类型
     */
    public static final String DATA_TYPE = "dataType";

    /**
     * 排序
     */
    public static final String CAN_SORT = "canSort";

    /**
     * 刷选
     */
    public static final String CAN_FILTER = "canFilter";

    /**
     * 请求
     */
    public static final String IS_REQUIRED = "isRequired";

    /**
     * 数组
     */
    public static final String IS_ARRAY = "isArray";

    /**
     * 值
     */
    public static final String VALUE = "value";

    /**
     * 子类
     */
    public static final String CHILDRENS = "childrens";

    /**
     * 默认版本1.0
     */
    public static final String API_VER = "1.0";

    /**
     * 分支首个版本
     */
    public static final String BRANCH_FIRST_API_VER = ".0";

    /**
     * 默认上一版本0.9
     */
    public static final String PER_API_VER = "0.9";

    /**
     * 草稿
     */
    public static final long APPROVED_STATUS_DRAFT = 1L;

    /**
     * 数据名称正则
     */
    public static final String REGEX_API_DATA_NAME = "[a-z0-9_]+";

    /**
     * openApi数据名称正则
     */
    public static final String REGEX_OPEN_API_DATA_NAME = "[a-zA-Z0-9_$]+";

    /**
     * 版本正则
     */
    public static final String REGEX_VERSION = "\\d+\\.\\d+";

    /**
     * 分支正则
     */
    public static final Pattern PATTERN_BRANCH = Pattern.compile(REGEX_VERSION);

    /**
     * 正则匹配
     */
    public static final String REGEX_COLUMN_TYPE_DETAIL_ALL = "(S{1}|[0-9]+){0,1}D(F{0,1})";

    /**
     * 正则匹配
     */
    public static final String REGEX_COLUMN_TYPE_DETAIL_HEADER = "(S{1}|[0-9]+){0,1}D";

    /**
     * 检验对象
     */
    public static final String[] ALLOW_API_DATA_NAME = new String[]{"CompanyId", "SiteId", "EntId"};

    /**
     * 检验对象
     */
    public static final String[] ALLOW_ARRAY_COLUMN_TYPE = new String[]{"M", "D", "SD"};

    /**
     * 检验对象
     */
    public static final String[] DATANAME_FATHER_UNREQUIRED = new String[]{"DATAKEY", "P", "M", "E", "H"};

    /**
     * 鼎捷内部租户Id
     */
    public static String TENANT_ID_DEFAULT = "99990000";

    /**
     * 检验对象
     */
    public static final String[] COLUMN_TYPE_E_DATA_NAME = new String[]{"code", "sql_code", "description"};

    /**
     * 分隔符
     */
    public static final String SPLITER = ",";

    /**
     * N
     */
    public static final String NO = "N";

    /**
     * EMPTY_NUMBER
     */
    public static final int EMPTY_NUMBER = -1;

    /**
     * Request
     */
    public static final String REQUEST = "Request";

    /**
     * Response success
     */
    public static final String REPONSE_SUCCESS = "Response success";

    /**
     * Response failed
     */
    public static final String REPONSE_FAILED = "Response failed";

    /**
     * StandardAPI
     */
    public static final String STANDARD_API = "StandardAPI";

    /**
     * 定版
     */
    public static final long APPROVED_STATUS_COMFIRMED = 4L;

    /**
     * 开发
     */
    public static final long APPROVED_STATUS_DEVELOPING = 3L;

    /**
     * 正则
     */
    public static final String REGEX_NUMBER = "[\\d]{1,3}[.].*";

    /**
     * 正则
     */
    public static final String REGEX_LIST_ENUM_MULT = "zh_TW:\\[([^.;\\[\\]]+(\\.[^.;\\[\\]]+)+)(;[^.;\\[\\]]+(\\.[^.;\\[\\]]+)+)*\\][\\t\\n\\r\\s]*zh_CN:\\[([^.;\\[\\]]+(\\.[^.;\\[\\]]+)+)(;[^.;\\[\\]]+(\\.[^.;\\[\\]]+)+)*\\][\\t\\n\\r\\s]*en_US:\\[([^.;\\[\\]]+(\\.[^.;\\[\\]]+)+)(;[^.;\\[\\]]+(\\.[^.;\\[\\]]+)+)*\\]";

    /**
     * 0-4為樣板，新增的api從第5個sheet開始
     */
    public static final int NEW_API_SHEET_NUMBER = 5;

    /**
     * 版本序列
     */
    public static final String[] VERSION_LIST = {"0.9", "1.0", "1.1", "1.2", "1.3", "1.4", "1.5", "1.6", "1.7", "1.8", "1.9", "1.10", "1.11", "1.12", "1.13", "1.14", "1.15", "1.16", "1.17", "1.18", "1.19", "1.20", "1.21", "1.22", "1.23", "1.24", "1.25", "1.26", "1.27", "1.28", "1.29", "1.30", "1.31", "1.32", "1.33", "1.34", "1.35", "1.36", "1.37", "1.38", "1.39", "1.40", "1.41", "1.42", "1.43", "1.44", "1.45", "1.46", "1.47", "1.48", "1.49", "1.50", "1.51", "1.52", "1.53", "1.54", "1.55", "1.56", "1.57", "1.58", "1.59", "1.60", "1.61", "1.62", "1.63", "1.64", "1.65", "1.66", "1.67", "1.68", "1.69", "1.70", "1.71", "1.72", "1.73", "1.74", "1.75", "1.76", "1.77", "1.78", "1.79", "1.80", "1.81", "1.82", "1.83", "1.84", "1.85", "1.86", "1.87", "1.88", "1.89", "1.90", "1.91", "1.92", "1.93", "1.94", "1.95", "1.96", "1.97", "1.98", "1.99"};

    /**
     * all
     */
    public static final String ALL = "all";

    /**
     * apiId
     */
    public static final String API_ID = "apiId";

    /**
     * 首次申请人
     */
    public static final String FIRST_APPLICANT = "firstApplicant";

    /**
     * 最后一次申请人
     */
    public static final String LAST_APPLICANT = "lastApplicant";

    /**
     * 设计租户ID
     */
    public static final String DESIGN_TENANT_ID = "designTenantId";

    /**
     * 设计teamId
     */
    public static final String TEAM_ID = "teamId";

    /**
     * 同步穩態產品服務版本對應至MDC
     */
    public static final String SUBJECT_SYNC_DEL_FAIL = "同步API元數據至MDC，同步刪除失敗.";

    /**
     * 同步穩態產品服務版本對應至MDC
     */
    public static final String SUBJECT_SYNC_ADD_FAIL = "同步API元數據至MDC，同步新增失敗.";

    /**
     * EARLIEST_TIME
     */
    public static String EARLIEST_TIME = "1000-01-01 00:00:00";

    /**
     * 描述繁中
     */
    public static final String DESC_ZH_TW = "descriptionZhTw";

    /**
     * 描述简中
     */
    public static final String DESC_ZH_CN = "descriptionZhCn";

    /**
     * 描述英文
     */
    public static final String DESC_EN_US = "descriptionEnUs";

    /**
     * 类别繁中
     */
    public static final String TYPE_ZH_TW = "typeZhTw";

    /**
     * 类别简中
     */
    public static final String TYPE_ZH_CN = "typeZhCn";

    /**
     * 类别英文
     */
    public static final String TYPE_EN_US = "typeEnUs";

    /**
     * 备注繁中
     */
    public static final String REMARK_ZH_TW = "remarkZhTw";

    /**
     * 备注简中
     */
    public static final String REMARK_ZH_CN = "remarkZhCn";

    /**
     * 备注英文
     */
    public static final String REMARK_EN_US = "remarkEnUs";

    /**
     * 审核描述信息
     */
    public static final String REJECT_DESC = "rejectDesc";

    /**
     * 词典命名格式
     */
    public static final String REGEX_DATA_NAME = "[a-z][a-z_]+";

    /**
     * 词典命名格式
     */
    public static final int MAX_COUNT = 10;

    /**
     * 下拉规格信息
     */
    public static final String DROPDOWN_MENU = "dropdownMenu";

    /**
     * 分页信息
     */
    public static final String API_PAGING = "apiPaging";

    /**
     * 分组细腻
     */
    public static final String API_GROUP = "apiGroup";

    /**
     * 同步
     */
    public static final String SYNC = "sync";

    /**
     * 异步
     */
    public static final String FASYNC = "fasync";

    /**
     * JSON
     */
    public static final String JSON = "JSON";

    /**
     * XML
     */
    public static final String XML = "XML";

    /**
     * JSON和XML
     */
    public static final String JSON_XML = "JSON,XML";

    /**
     * 列类型数组
     */
    public static final String[] COLUMN_TYPE_ARRAY = new String[]{"datakey", "H", "HF", "P", "M", "MF", "D", "DF", "SD", "SDF", "4D", "4DF", "5D", "5DF"};

    /**
     * 数据类型
     */
    public static final String[] DATE_TYPE_ARRAY = new String[]{"string", "numeric", "date", "boolean", "datetime", "time"};

    /**
     * 入参
     */
    public static final String STD_DATA = "std_data";

    /**
     * PARAMETER
     */
    public static final String PARAMETER = "parameter";

    /**
     * EXECUTION
     */
    public static final String EXECUTION = "execution";

    /**
     * MESSAGE_SPEC
     */
    public static final String MESSAGE_SPEC = "messageSpec";

    /**
     * PARENT
     */
    public static final String PARENT = "parent";

    /**
     * IS_BUSINESS_KEY
     */
    public static final String IS_BUSINESS_KEY = "isBusinessKey";

    /**
     * COLUMN_E
     */
    public static final String COLUMN_E = "E";

    /**
     * STRING
     */
    public static final String STRING = "string";

    /**
     * NUMERIC
     */
    public static final String NUMERIC = "numeric";

    /**
     * boolean
     */
    public static final String BOOLEAN = "boolean";

    /**
     * COLUMN_TYPE_ARRAY_OLD
     */
    public static final String[] COLUMN_TYPE_ARRAY_OLD = new String[]{"P", "M", "MF", "D", "DF", "SD", "SDF", "4D", "4DF", "5D", "5DF", "6D", "6DF", "7D", "7DF", "8D", "8DF", "9D", "9DF"};

    /**
     * DATANAME_FATHER_UNREQUIRED_OLD
     */
    public static final String[] DATANAME_FATHER_UNREQUIRED_OLD = new String[]{"P", "M"};

    /**
     * ALLOW_ARRAY_COLUMN_TYPE_OLD
     */
    public static final String[] ALLOW_ARRAY_COLUMN_TYPE_OLD = new String[]{"M", "D", "SD", "4D", "5D", "6D", "7D", "8D", "9D"};

    /**
     * NOT_ALLOW_ARRAY_COLUMN_TYPE
     */
    public static final String[] NOT_ALLOW_ARRAY_COLUMN_TYPE = new String[]{"H", "DATAKEY", "E"};

    /**
     * 用户
     */
    public static final String USER_NAME = "username";

    /**
     * 密钥
     */
    public static final String PWD_HASH = "pwdhash";

    /**
     * userToken
     */
    public static final String USERTOKEN = "userToken";

    /**
     * sheet密钥
     */
    public static final String SHEET_PASSWORD = "!QAZ2wsx";

    /**
     * 点分隔符
     */
    public static final String DOT = ".";

    /**
     * 資料列sheet在第1的位置
     */
    public static final int DATA_SHEET_NUMBER = 1;

    /**
     * 辭彙清單(審核)在第2的位置
     */
    public static final int AUDIT_USE_DATA_NAME_SHEET_NUMBER = 2;

    /**
     * 辭彙清單在第2的位置
     */
    public static final int DATA_NAME_SHEET_NUMBER = 3;

    /**
     * 範本sheet在第4的位置
     */
    public static final int TEMPLATE_SHEET_NUMBER = 4;

    /**
     * Standard API 資料列
     */
    public static final int STANDARD_API_ROW = 2;

    /**
     * Standard API 欄數
     */
    public static final int TOTAL_COLUMN_NUMBER = 22;

    /**
     * instance
     */
    public static final String INSTANCE = "instance";

    /**
     * pointer
     */
    public static final String POINTER = "pointer";

    /**
     * at
     */
    public static final String AT_STRING = " at ";

    /**
     * processor
     */
    public static final String PROCESSOR = "processor";

    /**
     * apimgmt
     */
    public static final String APIMGMT = "apimgmt";

    public static final String REQUEST_STRING = "request";

    public static final String KEY_STRING = "key";

    public static final String TYPE_STRING = "type";

    public static final String HOST_STRING = "host";

    public static final String SERVICE_STRING = "service";

    public static final String PROD_STRING = "prod";

    public static final String LANG_STRING = "lang";

    public static final String VER_STRING = "ver";

    public static final String IP_STRING = "ip";

    public static final String ACCT_STRING = "acct";

    public static final String TIMESTAMP_STRING = "timestamp";

    public static final String DATAKEY_STRING = "datakey";

    public static final String PAYLOAD_STRING = "payload";

    public static final String PARAM_STRING = "param";

    public static final String XML_STRING = "xml";

    public static final String SEQ_STRING = "seq";

    public static final String DETAIL_STRING = "detail";

    public static final String ROW_STRING = "row";

    public static final String FIELD_STRING = "field";

    public static final String DATAREQUEST_STRING = "data_request";

    public static final String DATAINFO_STRING = "datainfo";

    public static final String DATA_STRING = "data";

    public static final String CNT_STRING = "cnt";

    public static final String CNT_VALUE = "當前回傳資料筆數";

    public static final String TT_CNT_STRING = "tt_cnt";

    public static final String TT_CNT_VALUE = "應回傳的資料總筆數";

    public static final String UNDERSCORE_DATA_STRING = "_data";

    public static final String UNDERSCORE_ATTR_STRING = "_attr";

    public static final String RESPONSE_STRING = "response";

    public static final String DATA_RESPONSE_STRING = "data_response";

    public static final String MESSAGE_STRING = "message";

    public static final String SRVVER_STRING = "srvver";

    public static final String RES_REQID_STRING = "reqid";

    public static final String SRVCODE_STRING = "srvcode";

    public static final String CONTENT_ENCODE_HEADER_STRING = "Content-Type:application/json; charset=utf-8";

    public static final String DIGI_TYPE_STRING = "digi-type";

    public static final String DIGI_PROTOCOL_STRING = "digi-protocol";

    public static final String DIGI_KEY_STRING = "digi-key";

    public static final String DIGI_HOST_STRING = "digi-host";

    public static final String DIGI_SERVICE_STRING = "digi-service";

    public static final String DIGI_DATAKEY_STRING = "digi-datakey";

    public static final String DIGI_CODE_STRING = "digi-code";

    public static final String DIGI_MESSAGE_STRING = "digi-message";

    public static final String DIGI_REQID_STRING = "digi-reqid";

    public static final String DIGI_SRVCODE_STRING = "digi-srvcode";

    public static final String DIGI_SRVVER_STRING = "digi-srvver";

    public static final String PROD_RESPONSE_SUCCESS_STRING = "000";

    public static final String PROD_RESPONSE_FAILED_STRING = "100";

    /**
     * 标识且
     */
    public static final String MARK_AND = "and";

    /**
     * 标识或
     */
    public static final String MARK_OR = "or";

    /**
     * 条数
     */
    public static final String PAGE_SIZE = "pageSize";

    /**
     * 页号
     */
    public static final String PAGE_NUM = "pageNum";

    /**
     * 总数
     */
    public static final String PAGE_TOTAL = "pageTotal";

    /**
     * 操作类型  UPDATE/DELETE
     * Update(稳敏产品服务异动时) / Delete(执行地中台删除时)
     */
    public static final String ACTION = "action";

    /**
     * timestamp
     */
    public static final String TIMESTAMP = "timestamp";

    /**
     * type
     */
    public static final String INVOKED_TYPE = "type";

    /**
     * idempotency
     */
    public static final String IDEMPOTENCY = "idempotency";

    /**
     * data_metadata
     */
    public static final String DATA_METADATA = "data_metadata";

    /**
     * api_extend
     */
    public static final String API_EXTEND = "api_extend";

    /**
     * 路由
     */
    public static final String URL = "url";

    /**
     * 草稿
     */
    public static final String DRAFT_NUM = "draftNum";

    /**
     * 审核
     */
    public static final String UNDER_REVIEW_NUM = "underReview";

    /**
     * 开发
     */
    public static final String DEVELOPING_NUM = "developingNum";

    /**
     * 定版
     */
    public static final String CONFIRMED_NUM = "confirmedNum";

    /**
     * 停用
     */
    public static final String DEACTIVATE_NUM = "deactivateNum";

    /**
     * API默认分支
     */
    public static final String DEFAULT_BRANCH = "1.0";

    /**
     * API默认类型
     */
    public static final String DEFAULT_API_TYPE = ApiTypeConstants.DEFAULT_CODE;

    public static final String API_TYPE_OPENAPI = "openapi";

    /**
     * 默认关联Athena产品ID
     */
    public static final long DEFAULT_PROJECT = 1L;

    /**
     * 默认关联Athena产品名称
     */
    public static final String DEFAULT_PROJECT_NAME = "Athena";

    /**
     * 默认协议HTTP
     */
    public static final String DEFAULT_PROTOCOL = "HTTP";

    /**
     * 默认请求方法
     */
    public static final String DEFAULT_REQUEST_METHOD = "POST";

}