package com.digiwin.athena.apimgmt.constants;


/**
 * 请求方法常量类
 */
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class RequestMethodConstants {


	public final static String EMPTY = "";

	/* 请求方法名称 */
	public final static String POST_NAME = "POST";

	public final static String GET_NAME = "GET";

	public final static String PUT_NAME = "PUT";

	public final static String DELETE_NAME = "DELETE";

	/* 请求方法代码 */
	public final static String POST_CODE = "POST";

	public final static String GET_CODE = "GET";

	public final static String PUT_CODE = "PUT";

	public final static String DELETE_CODE = "DELETE";

	/* 请求方法数组 */
	public final static String[] REQUEST_METHOD_ARRAY = { POST_NAME, GET_NAME, PUT_NAME, DELETE_NAME };

	/**
	 * 根据请求方法名称获取请求方法代码
	 * @param pName 请求方法名称
	 * @return 请求方法代码
	 */
	public static String getCodeByName(String pName) {
		String tReturn;
		switch (pName) {
		case POST_NAME:
			tReturn = POST_CODE;
			break;
		case GET_NAME:
			tReturn = GET_CODE;
			break;
		case PUT_NAME:
			tReturn = PUT_CODE;
			break;
		case DELETE_NAME:
			tReturn = DELETE_CODE;
			break;
		default:
			tReturn = POST_NAME; // 默认返回POST
			log.error("Invalid Request Method Name: " + pName);
		}
		return tReturn;
	}

	/**
	 * 根据请求方法代码获取请求方法名称
	 * @param pCode 请求方法代码
	 * @return 请求方法名称
	 */
	public static String getNameByCode(String pCode) {
		String tReturn;
		if (POST_CODE.equals(pCode)) {
			tReturn = POST_NAME;
		} else if (GET_CODE.equals(pCode)) {
			tReturn = GET_NAME;
		} else if (PUT_CODE.equals(pCode)) {
			tReturn = PUT_NAME;
		} else if (DELETE_CODE.equals(pCode)) {
			tReturn = DELETE_NAME;
		} else {
			tReturn = EMPTY;
			log.error("Invalid Request Method Code: " + pCode);
		}
		return tReturn;
	}
}
