package com.digiwin.athena.apimgmt.dto;

import java.util.List;

/**
 * Pagination
 *
 * @author wangjy
 * @date 2021/9/12
 */
public class Pagination<T> {
    private Integer curPageNum;
    private Integer totalPageNum;
    private Integer limit;
    private Long total;

    private List<T> data;

    public Integer getCurPageNum() {
        return curPageNum;
    }

    public void setCurPageNum(Integer curPageNum) {
        this.curPageNum = curPageNum;
    }

    public Integer getTotalPageNum() {
        return totalPageNum;
    }

    public void setTotalPageNum(Integer totalPageNum) {
        this.totalPageNum = totalPageNum;
    }

    public Integer getLimit() {
        return limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Long getTotal() {
        return total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public List<T> getData() {
        return data;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public static <T> Pagination<T> buildPagination(PageReqCondition pageReqCondition, List<T> records, Long count) {
        Pagination<T> res = new Pagination<>();
        res.setData(records);
        res.setTotal(count);
        res.setCurPageNum(pageReqCondition.getPageNum());
        res.setTotalPageNum(count.intValue() / pageReqCondition.getPageSize() + 1);
        res.setLimit(pageReqCondition.getPageSize());

        return res;
    }
}