package com.digiwin.athena.apimgmt.dto;

import com.digiwin.athena.apimgmt.enums.ValidateStateEnum;

public class Response<T> {
    private String code;
    private String description;

    private T data;

    public static <T> Response<T> buildSuccess(T data){
        Response<T> objectResponse = new Response<>();
        objectResponse.setData(data);
        objectResponse.setCode(ValidateStateEnum.SUCCESS.getCode());
        return objectResponse;
    }

    public static Response buildFail(String message) {
        Response objectResponse = new Response<>();
        objectResponse.setDescription(message);
        objectResponse.setCode(ValidateStateEnum.UNEXPECTED_ERROR.getCode());
        return objectResponse;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }
}