package com.digiwin.athena.apimgmt.enums;

import com.fasterxml.jackson.databind.JsonNode;

import java.util.Optional;

/**
 * API相关构建信息
 */
public enum ApiAttributeEnum {
    apiName, apiId, version,
    apiDescription, apiRemark,
    apiTag, apiVersion, applicant,
    approvedStatus, editHistory,
    hostService, idempotency,
    invokeType, paging, productType,
    apiVersionList, messageExampleDownload,
    requesterSide, providerSide,
    requester, provider,
    hostProduct, serviceProduct,
    msgFormat, requestMessageSpec,
    responseMessageFailedSpec,
    responseMessageSuccessSpec,
    columnType, id, parent,
    dataName, dataType, isRequired,
    isDatakey, isArray, canSort,
    canFilter, isBusinessKey,
    dataDescription, dataDescriptionMultilingual,
    enumValue, dataNameRemark,
    dataNameRemarkMultilingual,
    dataEditHistory, template,
    fileLink, fileName, developRole,
    messageType, tenantId, searchType,
    apiDescriptionMultilingual,
    apiRemarkMultilingual, apiTagMultilingual,
    productTypeMultilingual,
    lang, value, listEnum, categoryId,
    categoryName, statusId,
    group, groupName, isBatch,
    checkResult, DraftDuplicate,
    UnderReviewDuplicate, DevelopingDuplicate,
    OtherUserDuplicate,
    userName, detailFileLink,
    wholeError, apiProcess, auditor,
    approvedTime, operation,
    operationDesc, userId, duplicateNumber,
    failedNum, ConfirmedDuplicate,
    listEnumMultilingual, designTenantId, designTenantName,
    parentApiName, parentBranch, parentApiTenantId,
    packageName, productPrecision,
    apiExtend, apiType, branch, protocol, requestMethod, apiPath,
    projectId,
    /**
     * 等价于projectName
     */
    projectCode,
    projectName, hasVersions,
    projectVersionIdList, projectVersionNameList,
    useProduct,source,
    isNew, isUpdate,apiParamText,textId;


    public Optional<JsonNode> getFrom(JsonNode node) {
        if (node == null) {
            return Optional.empty();
        }

        return Optional.ofNullable(node.get(this.toString()));
    }
}