package com.digiwin.athena.apimgmt.util;

import lombok.extern.slf4j.Slf4j;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * Digest Utility
 *
 * @author Cloude
 * @since 2010-05-14
 *
 */
@Slf4j
public class DigestUtil {

	/**
	 * 根據Hash的類型取得Digest的String
	 * 
	 * @param pHashType pHashType
	 * @param pSrcStr pSrcStr
	 * @return String
	 */
	public static String getDigestCode(String pHashType, String pSrcStr) {
		try {
			MessageDigest obj = MessageDigest.getInstance(pHashType);
			obj.update(pSrcStr.getBytes(StandardCharsets.UTF_8));
			byte[] digest = obj.digest();

			final StringBuilder buffer = new StringBuilder();
			for (final byte b : digest) {
				final int value = (b & 0x7F) + (b < 0 ? 128 : 0);
				buffer.append(value < 16 ? "0" : "");
				buffer.append(Integer.toHexString(value));
			}
			return buffer.toString();
		} catch (NoSuchAlgorithmException e) {
			log.error(e.getMessage());
		}
		return "";
	}
}
