package com.digiwin.athena.apimgmt.util;

import java.io.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtil {

	public static void zipDirOrFile(String pathFileOrDirWantToZip, String pathFileZipOut) throws IOException {
		File fileOrDirWantToZip = new File(pathFileOrDirWantToZip);
		File outZipFile = new File(pathFileZipOut);
		zipDirOrFile(fileOrDirWantToZip, outZipFile);
	}

	public static void zipDirOrFile(File fileOrDirWantToZip, File fileZipOut) throws IOException {
		zipDirOrFile(fileOrDirWantToZip, fileZipOut, null);
	}

	public static void zipDirOrFile(File fileOrDirWantToZip, File fileZipOut, String dirName) throws IOException {
		ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(fileZipOut));
		if (fileOrDirWantToZip.isFile()) {
			String dir;
			if (null == dirName || "".equals(dirName)) {
				dir = "";
			} else {
				dir = dirName + File.separator;
			}
			zipFile(zipOut, fileOrDirWantToZip, dir + fileOrDirWantToZip.getName());
		} else if (fileOrDirWantToZip.isDirectory()) {
			String dir;
			if (null == dirName || "".equals(dirName)) {
				dir = "";
			} else {
				dir = dirName;
			}
			zipDir(zipOut, fileOrDirWantToZip, dir);
		}
		zipOut.close();
	}

	private static void zipDir(ZipOutputStream zipOut, File dirWantToZip, String dirName) throws IOException {
		String dir;
		if (null == dirName || "".equals(dirName)) {
			dir = "";
		} else {
			dir = dirName + File.separator;
		}
		File[] files = dirWantToZip.listFiles();
		if (null != files) {
			for (File tFileOrDir : files) {
				if (tFileOrDir.isFile()) {
					zipFile(zipOut, tFileOrDir, dir + tFileOrDir.getName());
				} else if (tFileOrDir.isDirectory()) {
					zipDir(zipOut, tFileOrDir, dir + tFileOrDir.getName());
				}
			}
		}
	}

	private static void zipFile(ZipOutputStream zipOut, File fileWantToZip, String newFilePathInZip)
			throws IOException {
		try (InputStream input = new FileInputStream(fileWantToZip)) {
			zipOut.putNextEntry(new ZipEntry(newFilePathInZip));
			int temp;
			while ((temp = input.read()) != -1) {
				zipOut.write(temp);
			}
		}
	}

}
