/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.common.json;

import com.digiwin.athena.apimgmt.common.json.JsonSerializer;
import com.digiwin.athena.apimgmt.common.json.TypeReference;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import lombok.Generated;

public class JacksonJsonSerializer
implements JsonSerializer {
    private static ObjectMapper objectMapper;

    @Override
    public <T> T deserialize(String json, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("json\u53cd\u5e8f\u5217\u5316\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public <T> T deserialize(String json, Class<?> clazz, Class<?> ... genericClass) {
        try {
            JavaType javaType = objectMapper.getTypeFactory().constructParametricType(clazz, (Class[])genericClass);
            return (T)objectMapper.readValue(json, javaType);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("json\u53cd\u5e8f\u5217\u5316\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public <T> T deserialize(String json, TypeReference<T> typeReference) {
        try {
            return (T)objectMapper.readValue(json, typeReference.toJackson());
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("json\u53cd\u5e8f\u5217\u5316\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public String serialize(Object obj) {
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("json\u5e8f\u5217\u5316\u5f02\u5e38\uff01", e);
        }
    }

    @Generated
    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    @Generated
    public static void setObjectMapper(ObjectMapper objectMapper) {
        JacksonJsonSerializer.objectMapper = objectMapper;
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addSerializer(JsonObject.class, (com.fasterxml.jackson.databind.JsonSerializer)new JsonObjectSerializer());
        module.addSerializer(JsonElement.class, (com.fasterxml.jackson.databind.JsonSerializer)new JsonElementSerializer());
        objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)module);
    }

    static class JsonObjectSerializer
    extends com.fasterxml.jackson.databind.JsonSerializer<JsonObject> {
        JsonObjectSerializer() {
        }

        public void serialize(JsonObject value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeRawValue(value.toString());
        }
    }

    static class JsonElementSerializer
    extends com.fasterxml.jackson.databind.JsonSerializer<JsonElement> {
        JsonElementSerializer() {
        }

        public void serialize(JsonElement value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeRawValue(value.toString());
        }
    }
}

