/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DigestUtil.class);

    public static String getDigestCode(String pHashType, String pSrcStr) {
        try {
            MessageDigest obj = MessageDigest.getInstance(pHashType);
            obj.update(pSrcStr.getBytes(StandardCharsets.UTF_8));
            byte[] digest = obj.digest();
            StringBuilder buffer = new StringBuilder();
            byte[] byArray = digest;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                byte b;
                int value = (b & 0x7F) + ((b = byArray[i]) < 0 ? 128 : 0);
                buffer.append(value < 16 ? "0" : "");
                buffer.append(Integer.toHexString(value));
            }
            return buffer.toString();
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage());
            return "";
        }
    }
}

