/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    public static void zipDirOrFile(String pathFileOrDirWantToZip, String pathFileZipOut) throws IOException {
        File fileOrDirWantToZip = new File(pathFileOrDirWantToZip);
        File outZipFile = new File(pathFileZipOut);
        ZipUtil.zipDirOrFile(fileOrDirWantToZip, outZipFile);
    }

    public static void zipDirOrFile(File fileOrDirWantToZip, File fileZipOut) throws IOException {
        ZipUtil.zipDirOrFile(fileOrDirWantToZip, fileZipOut, null);
    }

    public static void zipDirOrFile(File fileOrDirWantToZip, File fileZipOut, String dirName) throws IOException {
        ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(fileZipOut));
        if (fileOrDirWantToZip.isFile()) {
            String dir = null == dirName || "".equals(dirName) ? "" : dirName + File.separator;
            ZipUtil.zipFile(zipOut, fileOrDirWantToZip, dir + fileOrDirWantToZip.getName());
        } else if (fileOrDirWantToZip.isDirectory()) {
            String dir = null == dirName || "".equals(dirName) ? "" : dirName;
            ZipUtil.zipDir(zipOut, fileOrDirWantToZip, dir);
        }
        zipOut.close();
    }

    private static void zipDir(ZipOutputStream zipOut, File dirWantToZip, String dirName) throws IOException {
        String dir = null == dirName || "".equals(dirName) ? "" : dirName + File.separator;
        File[] files = dirWantToZip.listFiles();
        if (null != files) {
            for (File tFileOrDir : files) {
                if (tFileOrDir.isFile()) {
                    ZipUtil.zipFile(zipOut, tFileOrDir, dir + tFileOrDir.getName());
                    continue;
                }
                if (!tFileOrDir.isDirectory()) continue;
                ZipUtil.zipDir(zipOut, tFileOrDir, dir + tFileOrDir.getName());
            }
        }
    }

    private static void zipFile(ZipOutputStream zipOut, File fileWantToZip, String newFilePathInZip) throws IOException {
        try (FileInputStream input = new FileInputStream(fileWantToZip);){
            int temp;
            zipOut.putNextEntry(new ZipEntry(newFilePathInZip));
            while ((temp = ((InputStream)input).read()) != -1) {
                zipOut.write(temp);
            }
        }
    }
}

