package com.digiwin.athena.apimgmt.rest.impl;

import com.digiwin.app.service.restful.DWRestfulRequest;
import com.digiwin.athena.apimgmt.apiservice.*;
import com.digiwin.athena.apimgmt.common.model.dto.FileDto;
import com.digiwin.athena.auth.annotation.FuncAuth;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
public class ApiMgmtAuthService {

    @Autowired
    private ApiImportCheckService apiImportCheckService;

    @Autowired
    private ApiImportService apiImportService;

    @Autowired
    private ApiReviewUpdateService apiReviewUpdateService;

    @Autowired
    private ApiDeleteService apiDeleteService;

    @Autowired
    private ApiExaminationPassedUpdateService apiExaminationPassedUpdateService;

    @Autowired
    private ApiRejectUpdateService apiRejectUpdateService;

    @Autowired
    private ApiComfirmedUpdateService apiComfirmedUpdateService;

    @Autowired
    private ApiSpecRetrieveUpdateService apiSpecRetrieveUpdateService;

    @Autowired
    private ApiSpecSaveService apiSpecSaveService;

    @Autowired
    private ApiSpecBatchSaveService apiSpecBatchSaveService;

    @FuncAuth(resourceType = "integration", actions = (":*"), resourceId = "Var:$tenantId")
    public Map<String, Object> apiImportCheckV2(FileDto file, DWRestfulRequest request) throws Exception {
        return apiImportCheckService.execute(file);
    }

    @FuncAuth(resourceType = "integration", actions = (":*"), resourceId = "Var:$tenantId")
    public Map<String, Object> apiImportV2(FileDto file, DWRestfulRequest request) throws Exception {
        return apiImportService.execute(file);
    }

    @FuncAuth(resourceType = "integration", actions = (":*"), resourceId = "Var:$tenantId")
    public Map<String, Object> apiReviewUpdateV2(DWRestfulRequest request) throws Exception {
        return apiReviewUpdateService.execute(request.getBodyAsString());
    }

    @FuncAuth(resourceType = "integration", actions = (":*"), resourceId = "Var:$tenantId")
    public Map<String, Object> apiDeleteV2(DWRestfulRequest request) throws Exception {
        return apiDeleteService.execute(request.getBodyAsString());

    }

    @FuncAuth(resourceType = "integration", actions = (":*"), resourceId = "Var:$tenantId")
    public Map<String, Object> apiExaminationPassedUpdateV2(DWRestfulRequest request) throws Exception {
        return apiExaminationPassedUpdateService.execute(request.getBodyAsString());
    }

    @FuncAuth(resourceType = "integration", actions = (":*"), resourceId = "Var:$tenantId")
    public Map<String, Object> apiRejectUpdateV2(DWRestfulRequest request) throws Exception {
        return apiRejectUpdateService.execute(request.getBodyAsString());
    }

    @FuncAuth(resourceType = "integration", actions = (":*"), resourceId = "Var:$tenantId")
    public Map<String, Object> apiConfirmedUpdateV2(DWRestfulRequest request) throws Exception {
        return apiComfirmedUpdateService.execute(request.getBodyAsString());
    }

    @FuncAuth(resourceType = "integration", actions = (":*"), resourceId = "Var:$tenantId")
    public Map<String, Object> apiSpecRetrieveUpdateV2(DWRestfulRequest request) throws Exception {
        return apiSpecRetrieveUpdateService.execute(request.getBodyAsString());
    }

    @FuncAuth(resourceType = "integration", actions = (":*"), resourceId = "Var:$tenantId")
    public Map<String, Object> apiSpecSaveV2(DWRestfulRequest request) throws Exception {
        return apiSpecSaveService.execute(request.getBodyAsString());
    }

    @FuncAuth(resourceType = "integration", actions = (":*"), resourceId = "Var:$tenantId")
    public Map<String, Object> apiSpecBatchSaveV2(DWRestfulRequest request) throws Exception {
        return apiSpecBatchSaveService.execute(request.getBodyAsString());
    }
}
