package com.digiwin.athena.apimgmt.infra.spring.http;

import cn.hutool.core.collection.CollUtil;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

@Data
public class RetryProp {
    public static final Entry HTTP_DEFAULT = Entry.of(3);
    public static final List<Integer> DEFAULT_RETRY_STATUS_CODES = CollUtil.newArrayList(401);

    private List<Entry> http = new ArrayList<>();

    @Data
    public static class Entry {
        /**
         * 匹配的URL
         */
        private String pattern;
        private boolean enabled;
        private int maxRetryCount;
        /**
         * 需要重试的状态码
         */
        private List<Integer> retryStatusCodes;

        public static Entry of(int maxRetryCount) {
            Entry entry = new Entry();

            entry.setEnabled(true);
            entry.setMaxRetryCount(maxRetryCount);

            return entry;
        }

        public List<Integer> getRetryStatusCodes() {
            return retryStatusCodes != null ? retryStatusCodes : DEFAULT_RETRY_STATUS_CODES;
        }

        public boolean needRetry(int statusCode) {
            List<Integer> retryStatus = getRetryStatusCodes();
            return retryStatus.contains(statusCode);
        }
    }
}
