/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.infra.spring.auth;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.apimgmt.infra.auth.ApiMgmtIdentity;
import com.digiwin.athena.apimgmt.infra.auth.IApiMgmtIdentityService;
import com.digiwin.athena.apimgmt.service.util.IamVerifyServiceUtil;
import com.digiwin.athena.apimgmt.services.ApiMgmtIamVerifyService;
import jakarta.annotation.Nullable;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiMgmtIamIdentityService
implements IApiMgmtIdentityService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtIamIdentityService.class);
    private final ApiMgmtIamVerifyService iamVerifyService;

    public ApiMgmtIamIdentityService(ApiMgmtIamVerifyService iamVerifyService) {
        this.iamVerifyService = iamVerifyService;
    }

    @Nullable
    public String getIntegrationToken(String tenantId) {
        return this.iamVerifyService.getIntegrationToken(tenantId);
    }

    @Nullable
    public String getTenantName(String tenantId) {
        ApiMgmtIdentity identity = this.parseToken(this.getIntegrationToken(tenantId));
        return identity != null ? identity.getTenantName() : null;
    }

    @Nullable
    public ApiMgmtIdentity parseToken(String token) {
        return this.parseUserInfo(token);
    }

    protected ApiMgmtIdentity parseUserInfo(String token) {
        if (StrUtil.isBlank((CharSequence)token)) {
            return null;
        }
        try {
            Map userInfo = this.iamVerifyService.getUserInfo(token);
            return ApiMgmtIdentity.builder().userId(MapUtil.getStr((Map)userInfo, (Object)"userId")).userName(MapUtil.getStr((Map)userInfo, (Object)"username")).tenantId(MapUtil.getStr((Map)userInfo, (Object)"tenantId")).tenantName(MapUtil.getStr((Map)userInfo, (Object)"tenantName")).teamIdSupplier(() -> this.teamIdSupplier(token)).teamTypeSupplier(identity -> IamVerifyServiceUtil.getTeamType((String)identity.getTeamId())).build();
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u7528\u6237\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)e);
            return null;
        }
    }

    protected String teamIdSupplier(String token) {
        try {
            return this.iamVerifyService.getTeamId(token);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u7528\u6237teamId\u5f02\u5e38\uff01", (Throwable)e);
            return null;
        }
    }
}

