/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.infra.spring.context;

import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.infra.auth.ApiMgmtIdentity;
import com.digiwin.athena.apimgmt.infra.auth.IApiMgmtIdentityService;
import com.digiwin.athena.apimgmt.infra.context.IApiMgmtServiceContext;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SpringApiMgmtServiceContext
implements IApiMgmtServiceContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringApiMgmtServiceContext.class);
    public static final String USER_ATTR = "__APIMGMT_USER";
    private final IApiMgmtIdentityService identitySupplier;

    public SpringApiMgmtServiceContext(IApiMgmtIdentityService identitySupplier) {
        this.identitySupplier = identitySupplier;
    }

    @Nullable
    public String getToken() {
        String token = StrUtil.toStringOrNull((Object)this.getRequestHeader().get("token"));
        if (StrUtil.isBlank((CharSequence)token)) {
            token = StrUtil.toStringOrNull((Object)this.getRequestHeader().get("digi-middleware-auth-user"));
        }
        return token;
    }

    public Optional<ApiMgmtIdentity> getUserInfo() {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        if (attributes == null) {
            return Optional.empty();
        }
        Optional<ApiMgmtIdentity> identity = (Optional<ApiMgmtIdentity>)attributes.getAttribute(USER_ATTR, 0);
        if (identity == null) {
            identity = Optional.ofNullable(this.identitySupplier.parseToken(this.getToken()));
            attributes.setAttribute(USER_ATTR, identity, 0);
        }
        return identity;
    }

    @Nullable
    public String getUserId() {
        return this.getUserInfo().map(ApiMgmtIdentity::getUserId).orElse(null);
    }

    @Nullable
    public String getUserName() {
        return this.getUserInfo().map(ApiMgmtIdentity::getUserName).orElse(null);
    }

    @Nullable
    public String getTenantId() {
        return this.getUserInfo().map(ApiMgmtIdentity::getTenantId).orElse(null);
    }

    @Nullable
    public String getTeamId() {
        return this.getUserInfo().map(ApiMgmtIdentity::getTeamId).orElse(null);
    }

    @Nullable
    public String getTeamType() {
        return this.getUserInfo().map(ApiMgmtIdentity::getTeamType).orElse(null);
    }

    @Nullable
    public String getLocale() {
        return StrUtil.toStringOrNull((Object)this.getRequestHeader().get(LocaleEnum.LOCALE.getType()));
    }

    @Nullable
    public String getRouterKey() {
        return StrUtil.toStringOrNull((Object)this.getRequestHeader().get("routerKey"));
    }

    public Map<String, Object> getRequestHeader() {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        HttpServletRequest request = this.getCurrentRequest();
        if (request == null) {
            log.warn("No current HttpServletRequest found in RequestContext");
            return headers;
        }
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            headers.put(headerName, request.getHeader(headerName));
        }
        return headers;
    }

    public Map<String, Object> getResponseHeader() {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        HttpServletResponse response = this.getCurrentResponse();
        if (response == null) {
            log.warn("No current HttpServletResponse found in RequestContext");
            return headers;
        }
        for (String headerName : response.getHeaderNames()) {
            headers.put(headerName, response.getHeader(headerName));
        }
        return headers;
    }

    private HttpServletRequest getCurrentRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            return ((ServletRequestAttributes)requestAttributes).getRequest();
        }
        return null;
    }

    private HttpServletResponse getCurrentResponse() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            return ((ServletRequestAttributes)requestAttributes).getResponse();
        }
        return null;
    }
}

