/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.infra.spring.http;

import cn.hutool.core.io.IoUtil;
import com.digiwin.athena.apimgmt.infra.spring.http.RetryProp;
import com.digiwin.athena.apimgmt.infra.spring.http.SpringHttpFailedException;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.web.client.DefaultResponseErrorHandler;

public class HttpRetryInterceptor
implements ClientHttpRequestInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpRetryInterceptor.class);
    private final RetryProp retryProp;
    private final AntPathMatcher pathMatcher = new AntPathMatcher();
    private final DefaultResponseErrorHandler errorHandler;

    public HttpRetryInterceptor(RetryProp retryProp) {
        this.retryProp = retryProp;
        this.errorHandler = new DefaultResponseErrorHandler();
    }

    @NonNull
    public ClientHttpResponse intercept(HttpRequest request, @NonNull byte[] body, @NonNull ClientHttpRequestExecution execution) throws IOException {
        URI originalUri = request.getURI();
        String serviceName = originalUri.getHost();
        Assert.state((serviceName != null ? 1 : 0) != 0, (String)("Request URI does not contain a valid hostname: " + originalUri));
        RetryProp.Entry retry = this.retryProp.getHttp().stream().filter(pattern -> this.pathMatcher.match(pattern.getPattern(), originalUri.getPath())).findFirst().orElse(RetryProp.HTTP_DEFAULT);
        if (!retry.isEnabled()) {
            if (log.isTraceEnabled()) {
                log.trace("Retry is disabled for {}", (Object)retry.getPattern());
            }
            return execution.execute(request, body);
        }
        RetryTemplate template = this.createRetryTemplate(retry);
        return (ClientHttpResponse)template.execute(context -> {
            try {
                ClientHttpResponse resp = execution.execute(request, body);
                HttpStatusCode status = resp.getStatusCode();
                if (retry.needRetry(status.value())) {
                    IoUtil.close((Closeable)resp);
                    this.errorHandler.handleError(resp);
                }
                return resp;
            }
            catch (IOException e) {
                throw new SpringHttpFailedException("http\u8bf7\u6c42\u5f02\u5e38\uff01", e);
            }
        });
    }

    private RetryTemplate createRetryTemplate(RetryProp.Entry retry) {
        RetryTemplate template = new RetryTemplate();
        template.setRetryPolicy((RetryPolicy)new SimpleRetryPolicy(retry.getMaxRetryCount()));
        template.setBackOffPolicy((BackOffPolicy)new ExponentialBackOffPolicy());
        template.setThrowLastExceptionOnExhausted(true);
        return template;
    }
}

