package com.digiwin.athena.apimgmt.infra.context;


import com.digiwin.athena.apimgmt.infra.auth.ApiMgmtIdentity;
import jakarta.annotation.Nullable;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class ApiMgmtServiceContextHolder {

    private static IApiMgmtServiceContext serviceContext;

    public static void setServiceContext(IApiMgmtServiceContext serviceContext) {
        ApiMgmtServiceContextHolder.serviceContext = serviceContext;
    }

    @Nullable
    public static String getToken() {
        return serviceContext.getToken();
    }

    @Nullable
    public static Optional<ApiMgmtIdentity> getUserInfo() {
        return serviceContext.getUserInfo();
    }

    @Nullable
    public static String getUserId() {
        return serviceContext.getUserId();
    }

    public static String getUserName() {
        return serviceContext.getUserName();
    }

    @Nullable
    public static String getTenantId() {
        return serviceContext.getTenantId();
    }

    public static String getTeamId() {
        return serviceContext.getTeamId();
    }

    @Nullable
    public static String getTeamType() {
        return serviceContext.getTeamType();
    }

    @Nullable
    public static String getLocale() {
        return serviceContext.getLocale();
    }

    @Nullable
    public static String getRouterKey() {
        return serviceContext.getRouterKey();
    }

    /**
     * 获取请求头信息
     * @apiNote 禁止业务层调用，使用更具体的如{@link ApiMgmtServiceContextHolder#getUserId()}
     *
     * @return 请求头Map
     */
    public static Map<String, Object> getRequestHeader() {
        Map<String, Object> requestHeader = serviceContext.getRequestHeader();
        return requestHeader != null ? requestHeader : Collections.emptyMap();
    }

    /**
     * 获取响应头信息
     *
     * @return 响应头Map
     */
    public static Map<String, Object> getResponseHeader() {
        Map<String, Object> responseHeader = serviceContext.getResponseHeader();
        if (responseHeader == null) {
            throw new IllegalStateException("responseHeader is null");
        }
        return responseHeader;
    }
}
