package com.digiwin.athena.apimgmt.infra.http;

import cn.hutool.core.convert.Convert;

import java.util.Collections;
import java.util.Map;

/**
 * HTTP客户端接口 - 抽象HTTP客户端功能
 * 提供HTTP请求发送、响应处理等功能
 */
public interface ApiMgmtHttpClientWrapper {
    /**
     * 执行自定义HTTP请求
     *
     * @param request      HTTP请求对象
     * @param responseType 响应类型
     * @return 响应对象
     */
    <T> T execute(HttpRequest request, Class<T> responseType);

    /**
     * 执行自定义HTTP请求（带选项）
     *
     * @param request      HTTP请求对象
     * @param responseType 响应类型
     * @param options      请求选项
     * @return 响应对象
     */
    <T> T execute(HttpRequest request, Class<T> responseType, RequestOption options);

    /**
     * 执行文件上传请求
     *
     * @param request      HTTP请求对象
     * @param file         要上传的文件
     * @param params       额外的表单参数（可选）
     * @param responseType 响应类型
     * @return 响应对象
     */
    <T> T uploadFile(HttpRequest request, MultipartFile file, Class<T> responseType);

    /**
     * 执行文件上传请求（带选项）
     *
     * @param request      HTTP请求对象
     * @param file         要上传的文件
     * @param params       额外的表单参数（可选）
     * @param responseType 响应类型
     * @param options      请求选项
     * @return 响应对象
     */
    <T> T uploadFile(HttpRequest request, MultipartFile file, Class<T> responseType, RequestOption options);

    default Map<String, Object> getBodyMap(HttpRequest request) {
        Object params = request.getBody();
        if (params != null) {
            //noinspection unchecked
            return Convert.convert(Map.class, params);
        }

        return Collections.emptyMap();
    }
}