package com.digiwin.athena.apimgmt.infra.http;

import lombok.Data;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;

/**
 * 请求处理接口 - 抽象请求处理功能
 * 提供参数获取、路径信息等请求相关功能
 */
@Data
public class HttpRequest {
    public static final String GET = "GET";
    public static final String POST = "POST";

    private URI url;
    private String method;

    private Map<String, String> headers = new HashMap<>();

    private Object body;

    public static HttpRequest ofPost(String url) {
        return ofMethod(POST, url);
    }

    public static HttpRequest ofGet(String url) {
        return ofMethod(GET, url);
    }

    public static HttpRequest ofMethod(String method, String url) {
        HttpRequest request = new HttpRequest();
        request.setUrl(URI.create(url));
        request.setMethod(method);

        return request;
    }

    public void setHeader(String key, Object val) {
        addHeader(key, val);
    }

    public void addHeader(String key, Object val) {
        headers.put(key, val != null ? val.toString() : null);
    }

    public void setEntity(Object body) {
        setBody(body);
    }
}