package com.digiwin.athena.apimgmt.infra.http;

import cn.hutool.core.io.IoUtil;
import lombok.Getter;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;

/**
 * 多部分文件封装类
 * 用于HTTP文件上传，封装文件名和文件内容
 */
public class MultipartFile {
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";

    @Getter
    private final String name;
    private final InputStream is;
    @Getter
    private final String contentType;
    @Getter
    private final String fileName;
    @Getter
    private final long size;

    public MultipartFile(String name, File file) {
        this(name, IoUtil.toStream(file), file.length(), APPLICATION_OCTET_STREAM, file.getName());
    }

    public MultipartFile(String name, InputStream is, long size, String fileName) {
        this(name, is, size, APPLICATION_OCTET_STREAM, fileName);
    }

    public MultipartFile(String name, byte[] is, String fileName) {
        this(name, new ByteArrayInputStream(is), is.length, APPLICATION_OCTET_STREAM, fileName);
    }

    public MultipartFile(String name, InputStream is, long size, String contentType, String fileName) {
        this.fileName = fileName;
        this.size = size;
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("文件名不能为空");
        }

        this.name = name;
        this.is = is;
        this.contentType = contentType != null ? contentType : APPLICATION_OCTET_STREAM;
    }

    public InputStream getInputStream() {
        return is;
    }



}
