package com.digiwin.athena.apimgmt.infra.util;

import com.digiwin.athena.apimgmt.infra.http.ApiMgmtHttpClientWrapper;
import com.digiwin.athena.apimgmt.infra.http.HttpRequest;
import com.digiwin.athena.apimgmt.infra.http.MultipartFile;
import com.digiwin.athena.apimgmt.infra.http.RequestOption;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class HttpUtil {
    private static ApiMgmtHttpClientWrapper clientWrapper;

    public static void setHttpClient(ApiMgmtHttpClientWrapper httpClient) {
        HttpUtil.clientWrapper = httpClient;
    }

    /**
     * 执行自定义HTTP请求
     *
     * @param request      HTTP请求对象
     * @param responseType 响应类型
     * @return 响应对象
     */
    public static <T> T execute(HttpRequest request, Class<T> responseType) {
        return clientWrapper.execute(request, responseType);
    }

    /**
     * 执行自定义HTTP请求（带选项）
     *
     * @param request      HTTP请求对象
     * @param responseType 响应类型
     * @param options      请求选项
     * @return 响应对象
     */
    public static <T> T execute(HttpRequest request, Class<T> responseType, RequestOption options) {
        return clientWrapper.execute(request, responseType, options);
    }

    /**
     * 执行文件上传请求
     *
     * @param request      HTTP请求对象
     * @param file         要上传的文件
     * @param responseType 响应类型
     * @return 响应对象
     */
    public static <T> T uploadFile(HttpRequest request, MultipartFile file, Class<T> responseType) {
        return clientWrapper.uploadFile(request, file, responseType);
    }

    /**
     * 执行文件上传请求（带选项）
     *
     * @param request      HTTP请求对象
     * @param file         要上传的文件
     * @param responseType 响应类型
     * @param options      请求选项
     * @return 响应对象
     */
    public static <T> T uploadFile(HttpRequest request, MultipartFile file, Class<T> responseType, RequestOption options) {
        return clientWrapper.uploadFile(request, file, responseType, options);
    }
}
