/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.infra.http;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class HttpRequest {
    public static final String GET = "GET";
    public static final String POST = "POST";
    private URI url;
    private String method;
    private Map<String, String> headers = new HashMap<String, String>();
    private Object body;

    public static HttpRequest ofPost(String url) {
        return HttpRequest.ofMethod(POST, url);
    }

    public static HttpRequest ofGet(String url) {
        return HttpRequest.ofMethod(GET, url);
    }

    public static HttpRequest ofMethod(String method, String url) {
        HttpRequest request = new HttpRequest();
        request.setUrl(URI.create(url));
        request.setMethod(method);
        return request;
    }

    public void setHeader(String key, Object val) {
        this.addHeader(key, val);
    }

    public void addHeader(String key, Object val) {
        this.headers.put(key, val != null ? val.toString() : null);
    }

    public void setEntity(Object body) {
        this.setBody(body);
    }

    @Generated
    public HttpRequest() {
    }

    @Generated
    public URI getUrl() {
        return this.url;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public Object getBody() {
        return this.body;
    }

    @Generated
    public void setUrl(URI url) {
        this.url = url;
    }

    @Generated
    public void setMethod(String method) {
        this.method = method;
    }

    @Generated
    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    @Generated
    public void setBody(Object body) {
        this.body = body;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequest)) {
            return false;
        }
        HttpRequest other = (HttpRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URI this$url = this.getUrl();
        URI other$url = other.getUrl();
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Object this$body = this.getBody();
        Object other$body = other.getBody();
        return !(this$body == null ? other$body != null : !this$body.equals(other$body));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Object $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HttpRequest(url=" + this.getUrl() + ", method=" + this.getMethod() + ", headers=" + this.getHeaders() + ", body=" + this.getBody() + ")";
    }
}

