/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.appparameter.utils;

import com.digiwin.athena.appparameter.exceptions.AppParameterException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SqlCommand {
    private static final Log LOGGER = LogFactory.getLog(SqlCommand.class);

    private SqlCommand() {
    }

    public static SqlCommand getInstance() {
        return InstanceHolder.instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTableExists(DataSource dataSource, String tableName) {
        try (Connection connection = dataSource.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            String catalog = connection.getCatalog();
            String schema = connection.getSchema();
            ResultSet tables = metaData.getTables(catalog, schema, tableName.toUpperCase(), new String[]{"TABLE"});
            boolean exists = tables.next();
            if (!exists) {
                tables = metaData.getTables(catalog, schema, tableName.toLowerCase(), new String[]{"TABLE"});
                exists = tables.next();
            }
            boolean bl = exists;
            return bl;
        }
        catch (Exception e) {
            throw new AppParameterException("Check table '" + tableName + "' error", e);
        }
    }

    public void execute(DataSource dataSource, String[] sqlScripts) {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            connection.setAutoCommit(Boolean.FALSE);
            try (Statement statement = connection.createStatement();){
                for (String sql : sqlScripts) {
                    statement.execute(sql);
                }
                connection.commit();
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
        }
        catch (Exception e) {
            throw new AppParameterException("Execute sql script error", e);
        }
        finally {
            if (Objects.nonNull(connection)) {
                try {
                    connection.setAutoCommit(Boolean.TRUE);
                    connection.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)"Closing jdbc connection error", (Throwable)e);
                }
            }
        }
    }

    private static class InstanceHolder {
        private static final SqlCommand instance = new SqlCommand();

        private InstanceHolder() {
        }
    }
}

