/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.async;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.thread.ThreadUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.DeployLog;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployVersion;
import com.digiwin.athena.athenadeployer.http.BackendApiHelper;
import com.digiwin.athena.athenadeployer.service.DeployerService;
import com.digiwin.athena.athenadeployer.service.PublishAfterService;
import com.digiwin.athena.athenadeployer.service.TenantService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

public class DeployFinishedTask
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployFinishedTask.class);
    private DeployerService deployerService;
    private List<String> applicationList;
    private List<String> tenantIdList;
    private Map<String, String> applicationCompileVersionMap;
    private DeployVersion deployVersionObj;
    private TenantService tenantService;
    private String environment;
    private PublishAfterService publishAfterService;
    private MongoTemplate mongoTemplate;
    private BackendApiHelper backendApiHelper;

    public DeployFinishedTask(List<String> applicationList, List<String> tenantIdList, DeployVersion deployVersionObj, String environment, Map<String, String> applicationCompileVersionMap) {
        this.applicationList = applicationList;
        this.tenantIdList = tenantIdList;
        this.deployVersionObj = deployVersionObj;
        this.environment = environment;
        this.applicationCompileVersionMap = applicationCompileVersionMap;
    }

    @Override
    public void run() {
        Integer majorVersionNum;
        this.deployerService.versionIncrease(this.deployVersionObj, this.applicationCompileVersionMap);
        ThreadUtil.execute(() -> {
            JSONObject publishProgressResult = (JSONObject)this.mongoTemplate.findOne(new Query().with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"majorVersionNum")})).limit(1), JSONObject.class, "publishProgressResult");
            Integer majorVersionNum = publishProgressResult.getInteger("majorVersionNum");
            String minorVersion = publishProgressResult.getString("minorVersion");
            String currentVersion = majorVersionNum + "." + minorVersion;
            Integer n = majorVersionNum;
            majorVersionNum = majorVersionNum + 1;
            String deployVersion = majorVersionNum + "." + minorVersion;
            JSONObject response = this.backendApiHelper.addApplicationVersion(deployVersion, currentVersion, "HuaweiTest-TEST");
            Boolean data = response.getBoolean("data");
            if (data != null && data.booleanValue()) {
                Update update = new Update();
                update.set("nextVersionCopied", (Object)true);
                this.mongoTemplate.upsert(new Query((CriteriaDefinition)Criteria.where((String)"_id").is(publishProgressResult.get((Object)"_id"))), (UpdateDefinition)update, "publishProgressResult");
            }
        });
        Integer n = majorVersionNum = this.deployVersionObj.getMajorVersionNum();
        majorVersionNum = majorVersionNum + 1;
        String deployVersion = majorVersionNum + "." + this.deployVersionObj.getMinorVersion();
        for (String application : this.applicationList) {
            if (CollUtil.isEmpty((Collection)this.tenantIdList)) {
                this.tenantIdList = this.tenantService.queryAllApplicationTenantId(application);
            }
            DeployLog deployLog = new DeployLog();
            deployLog.setApplication(application).setVersion(deployVersion).setTenantIdList(this.tenantIdList).setUser(AthenaUserLocal.getUser());
            this.deployerService.addDeployLog(deployLog);
        }
        if (!"DEV".equals(this.environment)) {
            this.deployerService.switchVersion(this.tenantIdList, deployVersion);
            this.publishAfterService.cacheReset();
        }
    }

    @Generated
    public DeployerService getDeployerService() {
        return this.deployerService;
    }

    @Generated
    public List<String> getApplicationList() {
        return this.applicationList;
    }

    @Generated
    public List<String> getTenantIdList() {
        return this.tenantIdList;
    }

    @Generated
    public Map<String, String> getApplicationCompileVersionMap() {
        return this.applicationCompileVersionMap;
    }

    @Generated
    public DeployVersion getDeployVersionObj() {
        return this.deployVersionObj;
    }

    @Generated
    public TenantService getTenantService() {
        return this.tenantService;
    }

    @Generated
    public String getEnvironment() {
        return this.environment;
    }

    @Generated
    public PublishAfterService getPublishAfterService() {
        return this.publishAfterService;
    }

    @Generated
    public MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    @Generated
    public BackendApiHelper getBackendApiHelper() {
        return this.backendApiHelper;
    }

    @Generated
    public DeployFinishedTask setDeployerService(DeployerService deployerService) {
        this.deployerService = deployerService;
        return this;
    }

    @Generated
    public DeployFinishedTask setApplicationList(List<String> applicationList) {
        this.applicationList = applicationList;
        return this;
    }

    @Generated
    public DeployFinishedTask setTenantIdList(List<String> tenantIdList) {
        this.tenantIdList = tenantIdList;
        return this;
    }

    @Generated
    public DeployFinishedTask setApplicationCompileVersionMap(Map<String, String> applicationCompileVersionMap) {
        this.applicationCompileVersionMap = applicationCompileVersionMap;
        return this;
    }

    @Generated
    public DeployFinishedTask setDeployVersionObj(DeployVersion deployVersionObj) {
        this.deployVersionObj = deployVersionObj;
        return this;
    }

    @Generated
    public DeployFinishedTask setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
        return this;
    }

    @Generated
    public DeployFinishedTask setEnvironment(String environment) {
        this.environment = environment;
        return this;
    }

    @Generated
    public DeployFinishedTask setPublishAfterService(PublishAfterService publishAfterService) {
        this.publishAfterService = publishAfterService;
        return this;
    }

    @Generated
    public DeployFinishedTask setMongoTemplate(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
        return this;
    }

    @Generated
    public DeployFinishedTask setBackendApiHelper(BackendApiHelper backendApiHelper) {
        this.backendApiHelper = backendApiHelper;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeployFinishedTask)) {
            return false;
        }
        DeployFinishedTask other = (DeployFinishedTask)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        DeployerService this$deployerService = this.getDeployerService();
        DeployerService other$deployerService = other.getDeployerService();
        if (this$deployerService == null ? other$deployerService != null : !this$deployerService.equals(other$deployerService)) {
            return false;
        }
        List this$applicationList = this.getApplicationList();
        List other$applicationList = other.getApplicationList();
        if (this$applicationList == null ? other$applicationList != null : !((Object)this$applicationList).equals(other$applicationList)) {
            return false;
        }
        List this$tenantIdList = this.getTenantIdList();
        List other$tenantIdList = other.getTenantIdList();
        if (this$tenantIdList == null ? other$tenantIdList != null : !((Object)this$tenantIdList).equals(other$tenantIdList)) {
            return false;
        }
        Map this$applicationCompileVersionMap = this.getApplicationCompileVersionMap();
        Map other$applicationCompileVersionMap = other.getApplicationCompileVersionMap();
        if (this$applicationCompileVersionMap == null ? other$applicationCompileVersionMap != null : !((Object)this$applicationCompileVersionMap).equals(other$applicationCompileVersionMap)) {
            return false;
        }
        DeployVersion this$deployVersionObj = this.getDeployVersionObj();
        DeployVersion other$deployVersionObj = other.getDeployVersionObj();
        if (this$deployVersionObj == null ? other$deployVersionObj != null : !this$deployVersionObj.equals(other$deployVersionObj)) {
            return false;
        }
        TenantService this$tenantService = this.getTenantService();
        TenantService other$tenantService = other.getTenantService();
        if (this$tenantService == null ? other$tenantService != null : !this$tenantService.equals(other$tenantService)) {
            return false;
        }
        String this$environment = this.getEnvironment();
        String other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        PublishAfterService this$publishAfterService = this.getPublishAfterService();
        PublishAfterService other$publishAfterService = other.getPublishAfterService();
        if (this$publishAfterService == null ? other$publishAfterService != null : !this$publishAfterService.equals(other$publishAfterService)) {
            return false;
        }
        MongoTemplate this$mongoTemplate = this.getMongoTemplate();
        MongoTemplate other$mongoTemplate = other.getMongoTemplate();
        if (this$mongoTemplate == null ? other$mongoTemplate != null : !this$mongoTemplate.equals(other$mongoTemplate)) {
            return false;
        }
        BackendApiHelper this$backendApiHelper = this.getBackendApiHelper();
        BackendApiHelper other$backendApiHelper = other.getBackendApiHelper();
        return !(this$backendApiHelper == null ? other$backendApiHelper != null : !this$backendApiHelper.equals(other$backendApiHelper));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeployFinishedTask;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DeployerService $deployerService = this.getDeployerService();
        result = result * 59 + ($deployerService == null ? 43 : $deployerService.hashCode());
        List $applicationList = this.getApplicationList();
        result = result * 59 + ($applicationList == null ? 43 : ((Object)$applicationList).hashCode());
        List $tenantIdList = this.getTenantIdList();
        result = result * 59 + ($tenantIdList == null ? 43 : ((Object)$tenantIdList).hashCode());
        Map $applicationCompileVersionMap = this.getApplicationCompileVersionMap();
        result = result * 59 + ($applicationCompileVersionMap == null ? 43 : ((Object)$applicationCompileVersionMap).hashCode());
        DeployVersion $deployVersionObj = this.getDeployVersionObj();
        result = result * 59 + ($deployVersionObj == null ? 43 : $deployVersionObj.hashCode());
        TenantService $tenantService = this.getTenantService();
        result = result * 59 + ($tenantService == null ? 43 : $tenantService.hashCode());
        String $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        PublishAfterService $publishAfterService = this.getPublishAfterService();
        result = result * 59 + ($publishAfterService == null ? 43 : $publishAfterService.hashCode());
        MongoTemplate $mongoTemplate = this.getMongoTemplate();
        result = result * 59 + ($mongoTemplate == null ? 43 : $mongoTemplate.hashCode());
        BackendApiHelper $backendApiHelper = this.getBackendApiHelper();
        result = result * 59 + ($backendApiHelper == null ? 43 : $backendApiHelper.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DeployFinishedTask(deployerService=" + String.valueOf(this.getDeployerService()) + ", applicationList=" + String.valueOf(this.getApplicationList()) + ", tenantIdList=" + String.valueOf(this.getTenantIdList()) + ", applicationCompileVersionMap=" + String.valueOf(this.getApplicationCompileVersionMap()) + ", deployVersionObj=" + String.valueOf(this.getDeployVersionObj()) + ", tenantService=" + String.valueOf(this.getTenantService()) + ", environment=" + this.getEnvironment() + ", publishAfterService=" + String.valueOf(this.getPublishAfterService()) + ", mongoTemplate=" + String.valueOf(this.getMongoTemplate()) + ", backendApiHelper=" + String.valueOf(this.getBackendApiHelper()) + ")";
    }
}

