/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.async;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.base.ResultBean;
import com.digiwin.athena.athenadeployer.domain.compile.CompileVersion;
import com.digiwin.athena.athenadeployer.http.BackendApiHelper;
import com.digiwin.athena.athenadeployer.http.DesignerApiHelper;
import com.digiwin.athena.athenadeployer.service.DeployerProgressService;
import com.digiwin.athena.athenadeployer.service.DeployerService;
import com.digiwin.athena.athenadeployer.utils.RedisCache;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployTask
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployTask.class);
    private Map<String, String> applicationCompileVersionMap = new HashMap();
    private List<String> applicationList;
    private String currentVersion;
    private AthenaUser athenaUser;
    private Boolean copyOtherApplication;
    private String deployVersion;
    private DesignerApiHelper designerApiHelper;
    private BackendApiHelper backendApiHelper;
    private DeployerService deployerService;
    private DeployerProgressService deployerProgressService;
    private RedisCache redisCache;

    public DeployTask(List<String> applicationList, String currentVersion, String deployVersion, Boolean copyOtherApplication, AthenaUser athenaUser) {
        this.applicationList = applicationList;
        this.currentVersion = currentVersion;
        this.deployVersion = deployVersion;
        this.athenaUser = athenaUser;
        this.copyOtherApplication = copyOtherApplication;
    }

    @Override
    public void run() {
        Iterator iterator = this.applicationList.iterator();
        while (iterator.hasNext()) {
            String appVersion;
            String application = (String)iterator.next();
            ResultBean resultBean = (ResultBean)this.designerApiHelper.queryCompileVersion(application).toJavaObject(ResultBean.class);
            JSONObject data = (JSONObject)resultBean.getData();
            CompileVersion compileVersionObj = (CompileVersion)data.toJavaObject(CompileVersion.class);
            DecimalFormat decimalFormat = new DecimalFormat("0000");
            String compileVersion = compileVersionObj.getMinorVersion() + "." + decimalFormat.format(compileVersionObj.getMajorVersion());
            JSONObject jsonObject = this.deployerService.queryGlobalVersion(this.currentVersion);
            JSONObject appCompileVersionMap = jsonObject.getJSONObject("applicationCompileVersionMap");
            if (MapUtil.isNotEmpty((Map)appCompileVersionMap) && StrUtil.isNotBlank((CharSequence)(appVersion = appCompileVersionMap.getString(application))) && appVersion.equals(compileVersion)) {
                log.info("{}\u7248\u672c\u7684{}\u5df2\u90e8\u7f72\u8fc7\uff0c\u65e0\u9700\u91cd\u590d\u90e8\u7f72", (Object)compileVersion, (Object)application);
                iterator.remove();
                continue;
            }
            JSONObject responseObj = this.backendApiHelper.deploy(application, compileVersion, this.currentVersion, this.deployVersion, this.copyOtherApplication, this.athenaUser, "HuaweiTest-TEST");
            if ("\u65e7\u7248\u6570\u636e\u590d\u5236\u5931\u8d25!".equals(responseObj.getString("msg"))) {
                this.deployerProgressService.deleteApplicationVersion(this.deployVersion);
            }
            this.applicationCompileVersionMap.put(application, compileVersion);
            this.redisCache.delete("DEPLOY_PROCESS", application);
        }
    }

    @Generated
    public Map<String, String> getApplicationCompileVersionMap() {
        return this.applicationCompileVersionMap;
    }

    @Generated
    public List<String> getApplicationList() {
        return this.applicationList;
    }

    @Generated
    public String getCurrentVersion() {
        return this.currentVersion;
    }

    @Generated
    public AthenaUser getAthenaUser() {
        return this.athenaUser;
    }

    @Generated
    public Boolean getCopyOtherApplication() {
        return this.copyOtherApplication;
    }

    @Generated
    public String getDeployVersion() {
        return this.deployVersion;
    }

    @Generated
    public DesignerApiHelper getDesignerApiHelper() {
        return this.designerApiHelper;
    }

    @Generated
    public BackendApiHelper getBackendApiHelper() {
        return this.backendApiHelper;
    }

    @Generated
    public DeployerService getDeployerService() {
        return this.deployerService;
    }

    @Generated
    public DeployerProgressService getDeployerProgressService() {
        return this.deployerProgressService;
    }

    @Generated
    public RedisCache getRedisCache() {
        return this.redisCache;
    }

    @Generated
    public DeployTask setApplicationCompileVersionMap(Map<String, String> applicationCompileVersionMap) {
        this.applicationCompileVersionMap = applicationCompileVersionMap;
        return this;
    }

    @Generated
    public DeployTask setApplicationList(List<String> applicationList) {
        this.applicationList = applicationList;
        return this;
    }

    @Generated
    public DeployTask setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
        return this;
    }

    @Generated
    public DeployTask setAthenaUser(AthenaUser athenaUser) {
        this.athenaUser = athenaUser;
        return this;
    }

    @Generated
    public DeployTask setCopyOtherApplication(Boolean copyOtherApplication) {
        this.copyOtherApplication = copyOtherApplication;
        return this;
    }

    @Generated
    public DeployTask setDeployVersion(String deployVersion) {
        this.deployVersion = deployVersion;
        return this;
    }

    @Generated
    public DeployTask setDesignerApiHelper(DesignerApiHelper designerApiHelper) {
        this.designerApiHelper = designerApiHelper;
        return this;
    }

    @Generated
    public DeployTask setBackendApiHelper(BackendApiHelper backendApiHelper) {
        this.backendApiHelper = backendApiHelper;
        return this;
    }

    @Generated
    public DeployTask setDeployerService(DeployerService deployerService) {
        this.deployerService = deployerService;
        return this;
    }

    @Generated
    public DeployTask setDeployerProgressService(DeployerProgressService deployerProgressService) {
        this.deployerProgressService = deployerProgressService;
        return this;
    }

    @Generated
    public DeployTask setRedisCache(RedisCache redisCache) {
        this.redisCache = redisCache;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeployTask)) {
            return false;
        }
        DeployTask other = (DeployTask)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$copyOtherApplication = this.getCopyOtherApplication();
        Boolean other$copyOtherApplication = other.getCopyOtherApplication();
        if (this$copyOtherApplication == null ? other$copyOtherApplication != null : !((Object)this$copyOtherApplication).equals(other$copyOtherApplication)) {
            return false;
        }
        Map this$applicationCompileVersionMap = this.getApplicationCompileVersionMap();
        Map other$applicationCompileVersionMap = other.getApplicationCompileVersionMap();
        if (this$applicationCompileVersionMap == null ? other$applicationCompileVersionMap != null : !((Object)this$applicationCompileVersionMap).equals(other$applicationCompileVersionMap)) {
            return false;
        }
        List this$applicationList = this.getApplicationList();
        List other$applicationList = other.getApplicationList();
        if (this$applicationList == null ? other$applicationList != null : !((Object)this$applicationList).equals(other$applicationList)) {
            return false;
        }
        String this$currentVersion = this.getCurrentVersion();
        String other$currentVersion = other.getCurrentVersion();
        if (this$currentVersion == null ? other$currentVersion != null : !this$currentVersion.equals(other$currentVersion)) {
            return false;
        }
        AthenaUser this$athenaUser = this.getAthenaUser();
        AthenaUser other$athenaUser = other.getAthenaUser();
        if (this$athenaUser == null ? other$athenaUser != null : !this$athenaUser.equals(other$athenaUser)) {
            return false;
        }
        String this$deployVersion = this.getDeployVersion();
        String other$deployVersion = other.getDeployVersion();
        if (this$deployVersion == null ? other$deployVersion != null : !this$deployVersion.equals(other$deployVersion)) {
            return false;
        }
        DesignerApiHelper this$designerApiHelper = this.getDesignerApiHelper();
        DesignerApiHelper other$designerApiHelper = other.getDesignerApiHelper();
        if (this$designerApiHelper == null ? other$designerApiHelper != null : !this$designerApiHelper.equals(other$designerApiHelper)) {
            return false;
        }
        BackendApiHelper this$backendApiHelper = this.getBackendApiHelper();
        BackendApiHelper other$backendApiHelper = other.getBackendApiHelper();
        if (this$backendApiHelper == null ? other$backendApiHelper != null : !this$backendApiHelper.equals(other$backendApiHelper)) {
            return false;
        }
        DeployerService this$deployerService = this.getDeployerService();
        DeployerService other$deployerService = other.getDeployerService();
        if (this$deployerService == null ? other$deployerService != null : !this$deployerService.equals(other$deployerService)) {
            return false;
        }
        DeployerProgressService this$deployerProgressService = this.getDeployerProgressService();
        DeployerProgressService other$deployerProgressService = other.getDeployerProgressService();
        if (this$deployerProgressService == null ? other$deployerProgressService != null : !this$deployerProgressService.equals(other$deployerProgressService)) {
            return false;
        }
        RedisCache this$redisCache = this.getRedisCache();
        RedisCache other$redisCache = other.getRedisCache();
        return !(this$redisCache == null ? other$redisCache != null : !this$redisCache.equals(other$redisCache));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeployTask;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $copyOtherApplication = this.getCopyOtherApplication();
        result = result * 59 + ($copyOtherApplication == null ? 43 : ((Object)$copyOtherApplication).hashCode());
        Map $applicationCompileVersionMap = this.getApplicationCompileVersionMap();
        result = result * 59 + ($applicationCompileVersionMap == null ? 43 : ((Object)$applicationCompileVersionMap).hashCode());
        List $applicationList = this.getApplicationList();
        result = result * 59 + ($applicationList == null ? 43 : ((Object)$applicationList).hashCode());
        String $currentVersion = this.getCurrentVersion();
        result = result * 59 + ($currentVersion == null ? 43 : $currentVersion.hashCode());
        AthenaUser $athenaUser = this.getAthenaUser();
        result = result * 59 + ($athenaUser == null ? 43 : $athenaUser.hashCode());
        String $deployVersion = this.getDeployVersion();
        result = result * 59 + ($deployVersion == null ? 43 : $deployVersion.hashCode());
        DesignerApiHelper $designerApiHelper = this.getDesignerApiHelper();
        result = result * 59 + ($designerApiHelper == null ? 43 : $designerApiHelper.hashCode());
        BackendApiHelper $backendApiHelper = this.getBackendApiHelper();
        result = result * 59 + ($backendApiHelper == null ? 43 : $backendApiHelper.hashCode());
        DeployerService $deployerService = this.getDeployerService();
        result = result * 59 + ($deployerService == null ? 43 : $deployerService.hashCode());
        DeployerProgressService $deployerProgressService = this.getDeployerProgressService();
        result = result * 59 + ($deployerProgressService == null ? 43 : $deployerProgressService.hashCode());
        RedisCache $redisCache = this.getRedisCache();
        result = result * 59 + ($redisCache == null ? 43 : $redisCache.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DeployTask(applicationCompileVersionMap=" + String.valueOf(this.getApplicationCompileVersionMap()) + ", applicationList=" + String.valueOf(this.getApplicationList()) + ", currentVersion=" + this.getCurrentVersion() + ", athenaUser=" + String.valueOf(this.getAthenaUser()) + ", copyOtherApplication=" + this.getCopyOtherApplication() + ", deployVersion=" + this.getDeployVersion() + ", designerApiHelper=" + String.valueOf(this.getDesignerApiHelper()) + ", backendApiHelper=" + String.valueOf(this.getBackendApiHelper()) + ", deployerService=" + String.valueOf(this.getDeployerService()) + ", deployerProgressService=" + String.valueOf(this.getDeployerProgressService()) + ", redisCache=" + String.valueOf(this.getRedisCache()) + ")";
    }
}

