/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.compile;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public abstract class AbstractDataCompile {
    @Autowired(required=false)
    @Qualifier(value="designerMongoTemplate")
    private MongoTemplate designerMongoTemplate;
    @Autowired(required=false)
    @Qualifier(value="kgsysMongoTemplate")
    private MongoTemplate kgsysMongoTemplate;

    protected void saveDiff(List<JSONObject> runtimeEntityList, List<JSONObject> designEntityList, String application, String module, String primaryKey) {
        List runtimeCodeList = runtimeEntityList.stream().map(runtimeEntity -> {
            String[] split = primaryKey.split(",");
            ArrayList<String> codeList = new ArrayList<String>();
            for (String s : split) {
                codeList.add(runtimeEntity.getString(s));
            }
            return String.join((CharSequence)",", codeList);
        }).collect(Collectors.toList());
        List designCodeList = designEntityList.stream().map(designEntity -> {
            String[] split = primaryKey.split(",");
            ArrayList<String> codeList = new ArrayList<String>();
            for (String s : split) {
                codeList.add(designEntity.getString(s));
            }
            return String.join((CharSequence)",", codeList);
        }).collect(Collectors.toList());
        Collection subtract = CollUtil.subtract(runtimeCodeList, designCodeList);
        Date date = new Date();
        if (CollUtil.isNotEmpty((Collection)subtract)) {
            for (String code : subtract) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("code", (Object)code);
                jsonObject.put("type", (Object)"onlyInRuntime");
                jsonObject.put("module", (Object)module);
                jsonObject.put("primaryKey", (Object)primaryKey);
                jsonObject.put("application", (Object)application);
                jsonObject.put("time", (Object)date);
                jsonObject.put("from", (Object)"transferCompare");
                this.designerMongoTemplate.save((Object)jsonObject, "entityDiff");
            }
        }
    }

    protected List<JSONObject> bean2JSONObject(List<?> beanList) {
        List<JSONObject> jsonObjectList = beanList.stream().map(bean -> {
            Map map = BeanUtil.beanToMap((Object)bean, (String[])new String[0]);
            JSONObject jsonObject = new JSONObject();
            map.forEach((k, v) -> jsonObject.put(k, v));
            return jsonObject;
        }).collect(Collectors.toList());
        return jsonObjectList;
    }

    public String getApplicationByAppCode(String appCode) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)appCode));
        JSONObject application = (JSONObject)this.kgsysMongoTemplate.findOne(query, JSONObject.class, "application");
        return String.valueOf(application.get((Object)"application"));
    }
}

