/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.compile.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.compile.AbstractDataCompile;
import com.digiwin.athena.athenadeployer.compile.DesignerDataCompile;
import com.digiwin.athena.athenadeployer.constant.Constant;
import com.digiwin.athena.athenadeployer.enums.SceneCodeEnum;
import com.digiwin.athena.athenadeployer.service.ExtendFieldDataService;
import com.digiwin.athena.athenadeployer.service.JsonDiffService;
import com.digiwin.athena.athenadeployer.utils.BatchFileDataIntegrationUtils;
import com.digiwin.athena.athenadeployer.utils.FileUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component(value="ActivityCompile")
public class ActivityCompile
extends AbstractDataCompile
implements DesignerDataCompile {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ActivityCompile.class);
    @Autowired
    BatchFileDataIntegrationUtils batchFileDataIntegrationUtils;
    @Autowired(required=false)
    @Qualifier(value="datamapMongoTemplate")
    private MongoTemplate datamapMongoTemplate;
    @Autowired
    private ExtendFieldDataService extendFieldDataService;
    @Autowired
    private JsonDiffService jsonDiffService;

    public void doCompile() {
        this.batchFileDataIntegrationUtils.batchFileDataIntegration(String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/", "mongo", "test", "activity"), String.format(Constant.ATHENA_DATA_PATH + "%s/%s/%s/", "mongo", "datamap", "activity"), SceneCodeEnum.DATAMAPACTIVITY.getValue(), "");
        String sourceFolder = Constant.DESIGNER_DATA_PATH + "mongo//test/flowGraph";
        String targerFolder = Constant.ATHENA_DATA_PATH + "mongo//datamap/flowGraph";
        FileUtils.copyFolder((String)sourceFolder, (String)targerFolder);
    }

    public void doCompile(String applicationCode) {
        List activitys = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "datamap", "activity"), JSONObject.class);
        activitys.forEach(activity -> {
            JSONObject config;
            String activityType = activity.getString("type");
            if (("esp".equals(activityType) || "http".equals(activityType)) && (config = activity.getJSONObject("config")) != null) {
                JSONObject headers = config.getJSONObject("headers");
                if (headers == null) {
                    headers = new JSONObject();
                }
                headers.put("security-token", (Object)"$(_ActLatelySecurityToken)");
                config.put("headers", (Object)headers);
                activity.put("config", (Object)config);
            }
            Object composeData = this.extendFieldDataService.combineWithExtendFieldData(activity.getString("code"), null, SceneCodeEnum.DATAMAPACTIVITY.getValue(), activity, applicationCode);
            FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + applicationCode + "/mongo/%s/%s/%s.json", "datamap", "activity", activity.get((Object)"code")), (Object)composeData);
        });
        String sourceFolder = Constant.DESIGNER_DATA_PATH + applicationCode + "/mongo/datamap/flowGraph";
        String targerFolder = Constant.ATHENA_DATA_PATH + applicationCode + "/mongo/datamap/flowGraph";
        FileUtils.copyFolder((String)sourceFolder, (String)targerFolder);
    }

    public void compileAndCompare(String applicationCode) {
        JSONObject runtimeEntity;
        String code;
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"application").is((Object)this.getApplicationByAppCode(applicationCode)));
        List runtimeEntityList = this.datamapMongoTemplate.find(query, JSONObject.class, "activity");
        List activityList = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "datamap", "activity"), JSONObject.class);
        this.saveDiff(runtimeEntityList, activityList, applicationCode, "datamap-activity", "code");
        for (JSONObject activity : activityList) {
            activity.remove((Object)"objectId");
            activity.remove((Object)"isMigrate");
            Object composeData = this.extendFieldDataService.combineWithExtendFieldData(activity.getString("code"), null, SceneCodeEnum.DATAMAPACTIVITY.getValue(), (Object)activity, applicationCode);
            code = activity.getString("code");
            runtimeEntity = runtimeEntityList.stream().filter(item -> code.equals(item.getString("code"))).findFirst().orElse(null);
            if (runtimeEntity == null) {
                log.info("\u5728\u8fd0\u884c\u6001\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53:{}", (Object)code);
            } else {
                runtimeEntity.remove((Object)"_id");
                runtimeEntity.remove((Object)"score");
                runtimeEntity.remove((Object)"_class");
                runtimeEntity.remove((Object)"athena_namespace");
                this.jsonDiffService.compare(JSON.toJSONString((Object)runtimeEntity), JSON.toJSONString((Object)composeData), "datamap-activity", applicationCode, "transferCompare");
            }
            FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "%s/%s/%s/%s/%s.json", applicationCode, "mongo", "datamap_publish", "activity", activity.getString("code")), (Object)composeData);
        }
        runtimeEntityList = this.datamapMongoTemplate.find(query, JSONObject.class, "flowGraph");
        List flowGraphList = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "datamap", "flowGraph"), JSONObject.class);
        this.saveDiff(runtimeEntityList, flowGraphList, applicationCode, "flowGraph", "code");
        for (JSONObject flowGraph : flowGraphList) {
            flowGraph.remove((Object)"objectId");
            flowGraph.remove((Object)"isMigrate");
            code = flowGraph.getString("code");
            runtimeEntity = runtimeEntityList.stream().filter(item -> code.equals(item.getString("code"))).findFirst().orElse(null);
            if (runtimeEntity == null) {
                log.info("\u5728\u8fd0\u884c\u6001\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53:{}", (Object)code);
            } else {
                runtimeEntity.remove((Object)"_id");
                runtimeEntity.remove((Object)"_class");
                runtimeEntity.remove((Object)"score");
                runtimeEntity.remove((Object)"athena_namespace");
                List nodes = ObjectUtils.isEmpty((Object)runtimeEntity.get((Object)"nodes")) ? new ArrayList() : (List)runtimeEntity.get((Object)"nodes");
                ArrayList nodesNew = new ArrayList();
                nodes.forEach(node -> {
                    JSONObject no = (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)node), JSONObject.class);
                    no.remove((Object)"_class");
                    nodesNew.add(no);
                });
                runtimeEntity.put("nodes", nodesNew);
                this.jsonDiffService.compare(JSON.toJSONString((Object)runtimeEntity), JSON.toJSONString((Object)flowGraph), "flowGraph", applicationCode, "transferCompare");
            }
            FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "%s/%s/%s/%s/%s.json", applicationCode, "mongo", "datamap_publish", "flowGraph", flowGraph.getString("code")), (Object)flowGraph);
        }
    }
}

