/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.compile.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.compile.AbstractDataCompile;
import com.digiwin.athena.athenadeployer.compile.DesignerDataCompile;
import com.digiwin.athena.athenadeployer.constant.Constant;
import com.digiwin.athena.athenadeployer.domain.ActivityConfigs;
import com.digiwin.athena.athenadeployer.enums.SceneCodeEnum;
import com.digiwin.athena.athenadeployer.service.ExtendFieldDataService;
import com.digiwin.athena.athenadeployer.service.JsonDiffService;
import com.digiwin.athena.athenadeployer.utils.BatchFileDataIntegrationUtils;
import com.digiwin.athena.athenadeployer.utils.FileUtils;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component(value="ActivityConfigsCompile")
public class ActivityConfigsCompile
extends AbstractDataCompile
implements DesignerDataCompile {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ActivityConfigsCompile.class);
    @Autowired
    BatchFileDataIntegrationUtils batchFileDataIntegrationUtils;
    @Autowired
    private ExtendFieldDataService extendFieldDataService;
    @Autowired(required=false)
    @Qualifier(value="kgsysMongoTemplate")
    private MongoTemplate kgsysMongoTemplate;
    @Autowired
    private JsonDiffService jsonDiffService;

    public void doCompile() {
    }

    public void doCompile(String applicationCode) {
        String path = String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "knowledgegraphSystem", "activityConfigs");
        List acList = FileUtils.readAllObjectFromFilePath((String)String.format(path, new Object[0]), ActivityConfigs.class);
        for (ActivityConfigs ac : acList) {
            Object composeData = this.extendFieldDataService.combineWithExtendFieldData(ac.getCode(), null, SceneCodeEnum.KGSYSACTIVITYCONFIGS.getValue(), (Object)ac, applicationCode);
            FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "/%s/mongo/%s/%s/%s.json", applicationCode, "knowledgegraphSystem", "activityConfigs", ac.getCode()), (Object)composeData);
        }
    }

    public void compileAndCompare(String applicationCode) {
        String path = String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "knowledgegraphSystem", "activityConfigs");
        List acList = FileUtils.readAllObjectFromFilePath((String)String.format(path, new Object[0]), ActivityConfigs.class);
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"application").is((Object)this.getApplicationByAppCode(applicationCode)));
        List runtimeEntityList = this.kgsysMongoTemplate.find(query, JSONObject.class, "activityConfigs");
        this.saveDiff(runtimeEntityList, this.bean2JSONObject(acList), applicationCode, "activityConfigs", "code");
        for (ActivityConfigs ac : acList) {
            Object composeData = this.extendFieldDataService.combineWithExtendFieldData(ac.getCode(), null, SceneCodeEnum.KGSYSACTIVITYCONFIGS.getValue(), (Object)ac, applicationCode);
            JSONObject runtimeEntity = runtimeEntityList.stream().filter(item -> ac.getCode().equals(item.getString("code"))).findFirst().orElse(null);
            if (runtimeEntity == null) {
                log.info("\u5728\u8fd0\u884c\u6001\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53:{}", (Object)ac.getCode());
            } else {
                runtimeEntity.remove((Object)"_id");
                runtimeEntity.remove((Object)"_class");
                runtimeEntity.remove((Object)"milestone");
                runtimeEntity.remove((Object)"athena_namespace");
                runtimeEntity.remove((Object)"emergency");
                runtimeEntity.remove((Object)"sequence");
                runtimeEntity.remove((Object)"executeType");
                runtimeEntity.remove((Object)"category");
                runtimeEntity.remove((Object)"pattern");
                runtimeEntity.remove((Object)"showFlow");
                runtimeEntity.remove((Object)"approveType");
                runtimeEntity.remove((Object)"startApproveActivity");
                runtimeEntity.remove((Object)"approves");
                runtimeEntity.remove((Object)"approve");
                runtimeEntity.remove((Object)"messages");
                runtimeEntity.remove((Object)"expectedDuration");
                runtimeEntity.remove((Object)"groupDispatchType");
                runtimeEntity.remove((Object)"assignAble");
                runtimeEntity.remove((Object)"tenantId");
                runtimeEntity.remove((Object)"assistant");
                runtimeEntity.remove((Object)"startApproveActivityName");
                runtimeEntity.remove((Object)"assignConfig");
                this.jsonDiffService.compare(JSON.toJSONString((Object)runtimeEntity), JSON.toJSONString((Object)composeData), "activityConfigs", applicationCode, "transferCompare");
            }
            FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "/%s/mongo/%s/%s/%s.json", applicationCode, "knowledgegraphSystem_publish", "activityConfigs", ac.getCode()), (Object)composeData);
        }
    }
}

