/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.compile.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.compile.AbstractDataCompile;
import com.digiwin.athena.athenadeployer.compile.DesignerDataCompile;
import com.digiwin.athena.athenadeployer.constant.Constant;
import com.digiwin.athena.athenadeployer.runtime.neo4j.domain.RuntimeActivity;
import com.digiwin.athena.athenadeployer.runtime.neo4j.repository.RuntimeActivityRepository;
import com.digiwin.athena.athenadeployer.service.JsonDiffService;
import com.digiwin.athena.athenadeployer.utils.FileUtils;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="ActivityNeo4jCompile")
public class ActivityNeo4jCompile
extends AbstractDataCompile
implements DesignerDataCompile {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ActivityNeo4jCompile.class);
    @Autowired(required=false)
    private RuntimeActivityRepository runtimeActivityRepository;
    @Autowired
    private JsonDiffService jsonDiffService;

    public void doCompile() {
    }

    public void doCompile(String applicationCode) {
        String sourceFolder = Constant.DESIGNER_DATA_PATH + applicationCode + "/neo4j/Activity";
        String targerFolder = Constant.ATHENA_DATA_PATH + applicationCode + "/neo4j/Activity";
        FileUtils.copyFolder((String)sourceFolder, (String)targerFolder);
    }

    public void compileAndCompare(String applicationCode) {
        List runtimeEntityList = this.runtimeActivityRepository.findByApplication(this.getApplicationByAppCode(applicationCode));
        List designEntityList = FileUtils.readAllObjectFromFilePath((String)(Constant.DESIGNER_DATA_PATH + applicationCode + "/neo4j/Activity"), JSONObject.class);
        this.saveDiff(this.bean2JSONObject(runtimeEntityList), designEntityList, applicationCode, "activity-neo4j", "code");
        for (JSONObject designEntity : designEntityList) {
            String code = designEntity.getString("code");
            designEntity.remove((Object)"isMigrate");
            designEntity.remove((Object)"labels");
            designEntity.remove((Object)"graphId");
            RuntimeActivity runtimeEntity = runtimeEntityList.stream().filter(item -> code.equals(item.getCode())).findFirst().orElse(null);
            if (runtimeEntity == null) {
                log.info("\u5728\u8fd0\u884c\u6001\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53:{}", (Object)code);
                continue;
            }
            runtimeEntity.setActionLabels(null);
            runtimeEntity.setGraphId(null);
            this.jsonDiffService.compare(JSON.toJSONString((Object)runtimeEntity), JSON.toJSONString((Object)designEntity), "Activity", applicationCode, "transferCompare");
        }
        String sourceFolder = Constant.DESIGNER_DATA_PATH + applicationCode + "/neo4j/Activity";
        String targerFolder = Constant.ATHENA_DATA_PATH + applicationCode + "/neo4j/Activity";
        FileUtils.copyFolder((String)sourceFolder, (String)targerFolder);
    }
}

