/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.compile.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.compile.AbstractDataCompile;
import com.digiwin.athena.athenadeployer.compile.DesignerDataCompile;
import com.digiwin.athena.athenadeployer.constant.Constant;
import com.digiwin.athena.athenadeployer.enums.SceneCodeEnum;
import com.digiwin.athena.athenadeployer.service.JsonDiffService;
import com.digiwin.athena.athenadeployer.utils.BatchFileDataIntegrationUtils;
import com.digiwin.athena.athenadeployer.utils.FileUtils;
import com.google.common.collect.Lists;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component(value="applicationCompile")
public class ApplicationCompile
extends AbstractDataCompile
implements DesignerDataCompile {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationCompile.class);
    @Autowired
    BatchFileDataIntegrationUtils batchFileDataIntegrationUtils;
    @Autowired(required=false)
    @Qualifier(value="kgsysMongoTemplate")
    private MongoTemplate kgsysMongoTemplate;
    @Autowired
    private JsonDiffService jsonDiffService;

    public void doCompile() {
        this.batchFileDataIntegrationUtils.batchFileDataIntegration(String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/", "mongo", "test", "application"), String.format(Constant.ATHENA_DATA_PATH + "%s/%s/%s/", "mongo", "knowledgegraphSystem", "application"), SceneCodeEnum.APPLICATION.getValue(), "");
    }

    public void doCompile(String applicationCode) {
        List appList = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "knowledgegraphSystem", "application"), JSONObject.class);
        for (JSONObject app : appList) {
            app.put("application", (Object)app.getString("code"));
            FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "%s/%s/%s/%s/%s.json", applicationCode, "mongo", "knowledgegraphSystem", "application", app.getString("code")), (Object)app);
        }
    }

    public void compileAndCompare(String applicationCode) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)applicationCode));
        JSONObject runtimeEntity = (JSONObject)this.kgsysMongoTemplate.findOne(query, JSONObject.class, "application");
        List appList = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "knowledgegraphSystem", "application"), JSONObject.class);
        this.saveDiff((List)Lists.newArrayList((Object[])new JSONObject[]{runtimeEntity}), appList, applicationCode, "application", "code");
        for (JSONObject app : appList) {
            app.remove((Object)"objectId");
            app.remove((Object)"isMigrate");
            String code = app.getString("code");
            if (runtimeEntity == null) {
                log.info("\u5728\u8fd0\u884c\u6001\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53:{}", (Object)code);
            } else {
                runtimeEntity.remove((Object)"_id");
                runtimeEntity.remove((Object)"paramDescription");
                runtimeEntity.remove((Object)"lang");
                runtimeEntity.remove((Object)"tags");
                runtimeEntity.remove((Object)"version");
                runtimeEntity.remove((Object)"athena_namespace");
                this.jsonDiffService.compare(JSON.toJSONString((Object)runtimeEntity), JSON.toJSONString((Object)app), "application", applicationCode, "transferCompare");
            }
            app.put("application", (Object)app.getString("code"));
            FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "%s/%s/%s/%s/%s.json", applicationCode, "mongo", "knowledgegraphSystem_publish", "application", app.getString("code")), (Object)app);
        }
    }
}

