/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.compile.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.compile.AbstractDataCompile;
import com.digiwin.athena.athenadeployer.compile.Applications;
import com.digiwin.athena.athenadeployer.compile.DesignerDataCompile;
import com.digiwin.athena.athenadeployer.constant.Constant;
import com.digiwin.athena.athenadeployer.service.JsonDiffService;
import com.digiwin.athena.athenadeployer.utils.FileUtils;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component(value="applicationRelationCompile")
public class ApplicationRelationCompile
extends AbstractDataCompile
implements DesignerDataCompile {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationRelationCompile.class);
    @Autowired(required=false)
    @Qualifier(value="kgsysMongoTemplate")
    private MongoTemplate kgsysMongoTemplate;
    @Autowired
    private JsonDiffService jsonDiffService;

    public void doCompile() {
        Set applicationCodes = Applications.getInstance().getApplicationSet();
        applicationCodes.forEach(applicationCode -> FileUtils.copyFolderWithoutNullValue((String)String.format(Constant.DESIGNER_DATA_PATH + "/%s/%s/%s/%s/", "mongo", applicationCode, "test", "applicationRelation"), (String)String.format(Constant.ATHENA_DATA_PATH + "%s/%s/%s/%s/", "mongo", applicationCode, "knowledgegraphSystem", "applicationRelation")));
    }

    public void doCompile(String applicationCode) {
        try {
            FileUtils.copyFolderWithoutNullValue((String)String.format(Constant.DESIGNER_DATA_PATH + "/%s/%s/%s/%s/", applicationCode, "mongo", "knowledgegraphSystem", "applicationRelation"), (String)String.format(Constant.ATHENA_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "knowledgegraphSystem", "applicationRelation"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void compileAndCompare(String applicationCode) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"appCode").is((Object)applicationCode));
        List runtimeEntityList = this.kgsysMongoTemplate.find(query, JSONObject.class, "applicationRelation");
        List arList = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "knowledgegraphSystem", "applicationRelation"), JSONObject.class);
        this.saveDiff(runtimeEntityList, arList, applicationCode, "applicationRelation", "code,type,appCode");
        for (JSONObject ar : arList) {
            String code = ar.getString("objectId") == null ? ar.getString("_id") : ar.getString("objectId");
            ar.remove((Object)"objectId");
            ar.remove((Object)"isMigrate");
            JSONObject runtimeEntity = runtimeEntityList.stream().filter(item -> ar.getString("appCode").equals(item.getString("appCode")) && ar.getString("code").equals(item.getString("code")) && ar.getString("type").equals(item.getString("type"))).findFirst().orElse(null);
            if (runtimeEntity == null) {
                log.info("\u5728\u8fd0\u884c\u6001\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53:{}", (Object)code);
                continue;
            }
            runtimeEntity.remove((Object)"_id");
            runtimeEntity.remove((Object)"application");
            runtimeEntity.remove((Object)"version");
            runtimeEntity.remove((Object)"_class");
            runtimeEntity.remove((Object)"objectId");
            runtimeEntity.remove((Object)"athena_namespace");
            this.jsonDiffService.compare(JSON.toJSONString((Object)runtimeEntity), JSON.toJSONString((Object)ar), "applicationRelation", applicationCode, "transferCompare");
        }
        FileUtils.copyFolderWithoutNullValue((String)String.format(Constant.DESIGNER_DATA_PATH + "/%s/%s/%s/%s/", applicationCode, "mongo", "knowledgegraphSystem", "applicationRelation"), (String)String.format(Constant.ATHENA_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "knowledgegraphSystem_publish", "applicationRelation"));
    }
}

