/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.compile.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.compile.AbstractDataCompile;
import com.digiwin.athena.athenadeployer.compile.Applications;
import com.digiwin.athena.athenadeployer.compile.DesignerDataCompile;
import com.digiwin.athena.athenadeployer.constant.Constant;
import com.digiwin.athena.athenadeployer.service.JsonDiffService;
import com.digiwin.athena.athenadeployer.utils.FileUtils;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component(value="dataCompile")
public class DataCompile
extends AbstractDataCompile
implements DesignerDataCompile {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataCompile.class);
    @Autowired(required=false)
    @Qualifier(value="datamapMongoTemplate")
    private MongoTemplate datamapMongoTemplate;
    @Autowired
    private JsonDiffService jsonDiffService;

    public void doCompile() {
        Set applicationCodes = Applications.getInstance().getApplicationSet();
        applicationCodes.forEach(applicationCode -> {
            FileUtils.copyFolder((String)String.format(Constant.DESIGNER_DATA_PATH + "/%s/%s/%s/", applicationCode, "test", "dataState"), (String)String.format(Constant.ATHENA_DATA_PATH + "/%s/%s/%s/", applicationCode, "datamap", "dataState"));
            FileUtils.copyFolder((String)String.format(Constant.DESIGNER_DATA_PATH + "/%s/%s/%s/", applicationCode, "test", "dataDescription"), (String)String.format(Constant.ATHENA_DATA_PATH + "/%s/%s/%s/", applicationCode, "datamap", "dataDescription"));
            FileUtils.copyFolder((String)String.format(Constant.DESIGNER_DATA_PATH + "/%s/%s/%s/", applicationCode, "test", "dataGroup"), (String)String.format(Constant.ATHENA_DATA_PATH + "/%s/%s/%s/", applicationCode, "datamap", "dataGroup"));
        });
    }

    public void doCompile(String applicationCode) {
        FileUtils.copyFolder((String)String.format(Constant.DESIGNER_DATA_PATH + "/%s/%s/%s/%s/", applicationCode, "mongo", "datamap", "dataState"), (String)String.format(Constant.ATHENA_DATA_PATH + "/%s/%s/%s/%s/", applicationCode, "mongo", "datamap", "dataState"));
        FileUtils.copyFolder((String)String.format(Constant.DESIGNER_DATA_PATH + "/%s/%s/%s/%s/", applicationCode, "mongo", "datamap", "dataDescription"), (String)String.format(Constant.ATHENA_DATA_PATH + "/%s/%s/%s/%s/", applicationCode, "mongo", "datamap", "dataDescription"));
        FileUtils.copyFolder((String)String.format(Constant.DESIGNER_DATA_PATH + "/%s/%s/%s/%s/", applicationCode, "mongo", "datamap", "dataGroup"), (String)String.format(Constant.ATHENA_DATA_PATH + "/%s/%s/%s/%s/", applicationCode, "mongo", "datamap", "dataGroup"));
    }

    public void compileAndCompare(String applicationCode) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"application").is((Object)this.getApplicationByAppCode(applicationCode)));
        List runtimeEntityList = this.datamapMongoTemplate.find(query, JSONObject.class, "dataGroup");
        List dgList = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "datamap", "dataGroup"), JSONObject.class);
        this.saveDiff(runtimeEntityList, dgList, applicationCode, "dataGroup", "code");
        for (Object dg : dgList) {
            dg.remove((Object)"objectId");
            dg.remove((Object)"isMigrate");
            String code = dg.getString("code");
            JSONObject runtimeEntity = runtimeEntityList.stream().filter(item -> code.equals(item.getString("code"))).findFirst().orElse(null);
            if (runtimeEntity == null) {
                log.info("\u5728\u8fd0\u884c\u6001\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53:{}", (Object)code);
            } else {
                runtimeEntity.remove((Object)"_id");
                runtimeEntity.remove((Object)"_class");
                runtimeEntity.remove((Object)"version");
                runtimeEntity.remove((Object)"athena_namespace");
                this.jsonDiffService.compare(JSON.toJSONString((Object)runtimeEntity), JSON.toJSONString((Object)dg), "dataGroup", applicationCode, "transferCompare");
            }
            FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "%s/%s/%s/%s/%s.json", applicationCode, "mongo", "datamap_publish", "dataGroup", code), (Object)dg);
        }
        runtimeEntityList = this.datamapMongoTemplate.find(query, JSONObject.class, "dataDescription");
        List ddList = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "datamap", "dataDescription"), JSONObject.class);
        this.saveDiff(runtimeEntityList, ddList, applicationCode, "dataDescription", "code");
        for (JSONObject dd : ddList) {
            dd.remove((Object)"objectId");
            dd.remove((Object)"isMigrate");
            String code = dd.getString("code");
            JSONObject runtimeEntity = runtimeEntityList.stream().filter(item -> code.equals(item.getString("code"))).findFirst().orElse(null);
            if (runtimeEntity == null) {
                log.info("\u5728\u8fd0\u884c\u6001\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53:{}", (Object)code);
            } else {
                runtimeEntity.remove((Object)"_id");
                runtimeEntity.remove((Object)"score");
                runtimeEntity.remove((Object)"_class");
                runtimeEntity.remove((Object)"version");
                runtimeEntity.remove((Object)"athena_namespace");
                this.jsonDiffService.compare(JSON.toJSONString((Object)runtimeEntity), JSON.toJSONString((Object)dd), "dataDescription", applicationCode, "transferCompare");
            }
            FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "%s/%s/%s/%s/%s.json", applicationCode, "mongo", "datamap_publish", "dataDescription", code), (Object)dd);
        }
        runtimeEntityList = this.datamapMongoTemplate.find(query, JSONObject.class, "dataState");
        List dsList = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "datamap", "dataState"), JSONObject.class);
        this.saveDiff(runtimeEntityList, dsList, applicationCode, "dataState", "code");
        for (JSONObject ds : dsList) {
            ds.remove((Object)"objectId");
            ds.remove((Object)"isMigrate");
            String code = ds.getString("code");
            JSONObject runtimeEntity = runtimeEntityList.stream().filter(item -> code.equals(item.getString("code"))).findFirst().orElse(null);
            if (runtimeEntity == null) {
                log.info("\u5728\u8fd0\u884c\u6001\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53:{}", (Object)code);
            } else {
                runtimeEntity.remove((Object)"_id");
                runtimeEntity.remove((Object)"score");
                runtimeEntity.remove((Object)"version");
                runtimeEntity.remove((Object)"_class");
                runtimeEntity.remove((Object)"athena_namespace");
                this.jsonDiffService.compare(JSON.toJSONString((Object)runtimeEntity), JSON.toJSONString((Object)ds), "dataState", applicationCode, "transferCompare");
            }
            FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "%s/%s/%s/%s/%s.json", applicationCode, "mongo", "datamap_publish", "dataState", code), (Object)ds);
        }
    }
}

